class ChangeDateToTimestamp < ActiveRecord::Migration
  def up
    safety_assured do
      change_column :access_tokens, :created_at, :datetime
      change_column :access_tokens, :updated_at, :datetime
      change_column :accounts, :created_at, :datetime
      change_column :accounts, :updated_at, :datetime
      change_column :accounts, :paid_at, :datetime
      change_column :accounts, :deleted_at, :datetime if column_exists?(:accounts, :deleted_at)
      change_column :accounts, :proxy_configs_updated_at, :datetime
      change_column :accounts, :proxy_configs_conf_updated_at, :datetime
      change_column :accounts, :hosted_proxy_deployed_at, :datetime
      change_column :accounts, :state_changed_at, :datetime
      change_column :alerts, :timestamp, :datetime
      change_column :api_docs_services, :created_at, :datetime
      change_column :api_docs_services, :updated_at, :datetime
      change_column :application_keys, :created_at, :datetime
      change_column :application_keys, :updated_at, :datetime
      change_column :audits, :created_at, :datetime
      change_column :authentication_providers, :created_at, :datetime
      change_column :authentication_providers, :updated_at, :datetime
      change_column :backend_api_configs, :created_at, :datetime
      change_column :backend_api_configs, :updated_at, :datetime
      change_column :backend_apis, :created_at, :datetime
      change_column :backend_apis, :updated_at, :datetime
      change_column :backend_events, :created_at, :datetime
      change_column :backend_events, :updated_at, :datetime
      change_column :billing_locks, :created_at, :datetime
      change_column :billing_strategies, :created_at, :datetime
      change_column :billing_strategies, :updated_at, :datetime
      change_column :categories, :created_at, :datetime
      change_column :categories, :updated_at, :datetime
      change_column :category_types, :created_at, :datetime
      change_column :category_types, :updated_at, :datetime
      change_column :cinstances, :created_at, :datetime
      change_column :cinstances, :updated_at, :datetime
      change_column :cinstances, :paid_until, :datetime
      change_column :cinstances, :trial_period_expires_at, :datetime
      change_column :cinstances, :variable_cost_paid_until, :datetime
      change_column :cinstances, :first_traffic_at, :datetime
      change_column :cinstances, :first_daily_traffic_at, :datetime
      change_column :cinstances, :accepted_at, :datetime
      change_column :cms_files, :attachment_updated_at, :datetime
      change_column :cms_files, :created_at, :datetime
      change_column :cms_files, :updated_at, :datetime
      change_column :cms_groups, :created_at, :datetime
      change_column :cms_groups, :updated_at, :datetime
      change_column :cms_permissions, :created_at, :datetime
      change_column :cms_permissions, :updated_at, :datetime
      change_column :cms_redirects, :created_at, :datetime
      change_column :cms_redirects, :updated_at, :datetime
      change_column :cms_sections, :created_at, :datetime
      change_column :cms_sections, :updated_at, :datetime
      change_column :cms_templates, :created_at, :datetime
      change_column :cms_templates, :updated_at, :datetime
      change_column :cms_templates_versions, :created_at, :datetime
      change_column :cms_templates_versions, :updated_at, :datetime
      change_column :configuration_values, :created_at, :datetime
      change_column :configuration_values, :updated_at, :datetime
      change_column :countries, :created_at, :datetime
      change_column :countries, :updated_at, :datetime
      change_column :deleted_objects, :created_at, :datetime
      change_column :end_user_plans, :created_at, :datetime
      change_column :end_user_plans, :updated_at, :datetime
      change_column :event_store_events, :created_at, :datetime
      change_column :features, :created_at, :datetime
      change_column :features, :updated_at, :datetime
      change_column :fields_definitions, :created_at, :datetime
      change_column :fields_definitions, :updated_at, :datetime
      change_column :gateway_configurations, :created_at, :datetime
      change_column :gateway_configurations, :updated_at, :datetime
      change_column :go_live_states, :created_at, :datetime
      change_column :go_live_states, :updated_at, :datetime
      change_column :invitations, :sent_at, :datetime
      change_column :invitations, :created_at, :datetime
      change_column :invitations, :updated_at, :datetime
      change_column :invitations, :accepted_at, :datetime
      change_column :invoice_counters, :created_at, :datetime
      change_column :invoice_counters, :updated_at, :datetime
      change_column :invoices, :paid_at, :datetime
      change_column :invoices, :created_at, :datetime
      change_column :invoices, :updated_at, :datetime
      change_column :invoices, :pdf_updated_at, :datetime
      change_column :invoices, :finalized_at, :datetime
      change_column :legal_term_acceptances, :created_at, :datetime
      change_column :legal_term_acceptances, :updated_at, :datetime
      change_column :legal_term_bindings, :created_at, :datetime
      change_column :legal_term_bindings, :updated_at, :datetime
      change_column :legal_term_versions, :created_at, :datetime
      change_column :legal_term_versions, :updated_at, :datetime
      change_column :legal_terms, :created_at, :datetime
      change_column :legal_terms, :updated_at, :datetime
      change_column :line_items, :created_at, :datetime
      change_column :line_items, :updated_at, :datetime
      change_column :line_items, :finished_at, :datetime
      change_column :log_entries, :created_at, :datetime
      change_column :log_entries, :updated_at, :datetime
      change_column :mail_dispatch_rules, :created_at, :datetime
      change_column :mail_dispatch_rules, :updated_at, :datetime
      change_column :member_permissions, :created_at, :datetime
      change_column :member_permissions, :updated_at, :datetime
      change_column :message_recipients, :hidden_at, :datetime
      change_column :message_recipients, :deleted_at, :datetime
      change_column :messages, :hidden_at, :datetime
      change_column :messages, :created_at, :datetime
      change_column :messages, :updated_at, :datetime
      change_column :metrics, :created_at, :datetime
      change_column :metrics, :updated_at, :datetime
      change_column :moderatorships, :created_at, :datetime
      change_column :moderatorships, :updated_at, :datetime
      change_column :notification_preferences, :created_at, :datetime
      change_column :notification_preferences, :updated_at, :datetime
      change_column :notifications, :created_at, :datetime
      change_column :notifications, :updated_at, :datetime
      change_column :oidc_configurations, :created_at, :datetime
      change_column :oidc_configurations, :updated_at, :datetime
      change_column :onboardings, :created_at, :datetime
      change_column :onboardings, :updated_at, :datetime
      change_column :partners, :created_at, :datetime
      change_column :partners, :updated_at, :datetime
      change_column :payment_details, :created_at, :datetime
      change_column :payment_details, :updated_at, :datetime
      change_column :payment_gateway_settings, :created_at, :datetime
      change_column :payment_gateway_settings, :updated_at, :datetime
      change_column :payment_transactions, :created_at, :datetime
      change_column :payment_transactions, :updated_at, :datetime
      change_column :plan_metrics, :created_at, :datetime
      change_column :plan_metrics, :updated_at, :datetime
      change_column :plans, :created_at, :datetime
      change_column :plans, :updated_at, :datetime
      change_column :policies, :created_at, :datetime
      change_column :policies, :updated_at, :datetime
      change_column :posts, :created_at, :datetime
      change_column :posts, :updated_at, :datetime
      change_column :pricing_rules, :created_at, :datetime
      change_column :pricing_rules, :updated_at, :datetime
      change_column :profiles, :created_at, :datetime
      change_column :profiles, :updated_at, :datetime
      change_column :provided_access_tokens, :expires_at, :datetime
      change_column :provided_access_tokens, :created_at, :datetime
      change_column :provided_access_tokens, :updated_at, :datetime
      change_column :provider_constraints, :created_at, :datetime
      change_column :provider_constraints, :updated_at, :datetime
      change_column :proxies, :deployed_at, :datetime
      change_column :proxies, :created_at, :datetime
      change_column :proxies, :updated_at, :datetime
      change_column :proxy_config_affecting_changes, :created_at, :datetime
      change_column :proxy_config_affecting_changes, :updated_at, :datetime
      change_column :proxy_configs, :created_at, :datetime
      change_column :proxy_configs, :updated_at, :datetime
      change_column :proxy_logs, :created_at, :datetime
      change_column :proxy_logs, :updated_at, :datetime
      change_column :proxy_rules, :created_at, :datetime
      change_column :proxy_rules, :updated_at, :datetime
      change_column :referrer_filters, :created_at, :datetime
      change_column :referrer_filters, :updated_at, :datetime
      change_column :service_cubert_infos, :created_at, :datetime
      change_column :service_cubert_infos, :updated_at, :datetime
      change_column :service_tokens, :created_at, :datetime
      change_column :service_tokens, :updated_at, :datetime
      change_column :services, :created_at, :datetime
      change_column :services, :updated_at, :datetime
      change_column :settings, :created_at, :datetime
      change_column :settings, :updated_at, :datetime
      change_column :slugs, :created_at, :datetime
      change_column :sso_authorizations, :created_at, :datetime
      change_column :sso_authorizations, :updated_at, :datetime
      change_column :system_operations, :created_at, :datetime
      change_column :system_operations, :updated_at, :datetime
      change_column :taggings, :created_at, :datetime
      change_column :taggings, :updated_at, :datetime
      change_column :tags, :created_at, :datetime
      change_column :tags, :updated_at, :datetime
      change_column :topic_categories, :created_at, :datetime
      change_column :topic_categories, :updated_at, :datetime
      change_column :topics, :created_at, :datetime
      change_column :topics, :updated_at, :datetime
      change_column :topics, :last_updated_at, :datetime
      change_column :usage_limits, :created_at, :datetime
      change_column :usage_limits, :updated_at, :datetime
      change_column :user_sessions, :accessed_at, :datetime
      change_column :user_sessions, :revoked_at, :datetime
      change_column :user_sessions, :created_at, :datetime
      change_column :user_sessions, :updated_at, :datetime
      change_column :user_sessions, :secured_until, :datetime
      change_column :user_topics, :created_at, :datetime
      change_column :user_topics, :updated_at, :datetime
      change_column :users, :created_at, :datetime
      change_column :users, :updated_at, :datetime
      change_column :users, :remember_token_expires_at, :datetime
      change_column :users, :activated_at, :datetime
      change_column :users, :last_login_at, :datetime
      change_column :users, :lost_password_token_generated_at, :datetime
      change_column :web_hooks, :created_at, :datetime
      change_column :web_hooks, :updated_at, :datetime
    end
  end
end
