# frozen_string_literal: true

if ENV['CI']
  require 'simplecov'
  SimpleCov.start

  require 'codecov'
  SimpleCov.formatter = SimpleCov::Formatter::Codecov
end

# IMPORTANT: This file is generated by cucumber-rails - edit at your own peril.
# It is recommended to regenerate this file in the future when you upgrade to a
# newer version of cucumber-rails. Consider adding your own code to a new file
# instead of editing this one. Cucumber will automatically load all features/**/*.rb
# files.

require 'cucumber/formatter/unicode' # Remove this line if you don't want Cucumber Unicode support

non_transactional = %w[
  @backend
  @emails
  @stats
  @search
  @audit
  @commit-transactions
].freeze

transactional = non_transactional.map {|t| "~#{t}" }

Before do
  IndexProxyRuleWorker.stubs(:perform_later)
end

Before transactional.join(' or ') do
  Cucumber::Rails::Database.before_js if Cucumber::Rails::Database.autorun_database_cleaner
end

Before non_transactional.join(' or ') do
  Cucumber::Rails::Database.before_non_js if Cucumber::Rails::Database.autorun_database_cleaner
end

require 'cucumber/rails'
require 'cucumber/rails/rspec'


# require 'cucumber/rails/capybara_javascript_emulation' # Lets you click links with onclick javascript handlers without using @culerity or @javascript
#
# Capybara defaults to XPath selectors rather than Webrat's default of CSS3. In
# order to ease the transition to Capybara we set the default here. If you'd
# prefer to use XPath just remove this line and adjust any selectors in your
# steps to use the XPath syntax.
Capybara.default_selector = :css

# By default, any exception happening in your Rails application will bubble up
# to Cucumber so that your scenario will fail. This is a different from how
# your application behaves in the production environment, where an error page will
# be rendered instead.
#
# Sometimes we want to override this default behaviour and allow Rails to rescue
# exceptions and display an error page (just like when the app is running in production).
# Typical scenarios where you want to do this is when you test your error pages.
# There are two ways to allow Rails to rescue exceptions:
#
# 1) Tag your scenario (or feature) with @allow-rescue
#
# 2) Set the value below to true. Beware that doing this globally is not
# recommended as it will mask a lot of errors for you!
#
ActionController::Base.allow_rescue = false

# Possible values are :truncation and :transaction
# The :transaction strategy is faster, but might give you threading problems.
# See https://github.com/cucumber/cucumber-rails/blob/master/features/choose_javascript_database_strategy.feature
Cucumber::Rails::Database.javascript_strategy = :truncation

DatabaseCleaner.clean_with(:truncation)

# lets load webmock as soon as possible,
# because we load all test helpers (yikes) in support/test_helpers.rb
# and there the webmock is not initialized properly
require_relative 'webmock'
