# Building

Please have a look at the Red Hat Productization [docs for building 3scale]
(https://docs.engineering.redhat.com/display/JP/3scale-AMP+Build+and+Release+Process).

Build targets you might find useful:

* `update-base-image`: to update the Dockerfiles' base image
* `cache.tar.gz`: for updating gem dependencies

# Creating the release Docker image

Make sure you have all your changes committed and pushed, included whatever updates to cache.tar.gz.

1. Run `make build smoke`.

2. If everything is ok, you can go for `make test`.

3. Download (pull) the new image (BREW will output this in the web interface).

4. Run `make SMOKE_IMAGE=local:image smoke`.

5. Make sure you are on the release branch with all changes pushed and run `make brew`.

6. Note: Step 5 should use brew-ga-release (and step 2, test-ga-release) for
   a GA release. That makes brew pull in the Puddle repositories.
