var options =	{chart: {
		renderTo: 'pie',
		defaultSeriesType: 'line',
    margin: [0,0,0,0]	
  },
  colors: ['#B23600', '#FF8A00', '#FFC887', '#CC5400', '#89B233'],    
  credits: {enabled: false},  	
	title: {
		text: null
	},
	tooltip: {
		formatter: function() {
			return '<b>'+ this.point.name +'</b>:<br/>'+ 
				this.y +' subscriptions<br/>'+
				'('+ Highcharts.numberFormat(this.percentage, 1) +'%)';
		}
	},
	legend: {
		enabled: false
	},
	series: [{
		type: 'pie',
		name: 'Signups',
		data: [],
		allowPointSelect: true,
		cursor: 'pointer',
		center: ['50%', '48%'],
		size: 150,
		showInLegend: false,
		dataLabels: {
			enabled: true,
			formatter: function() {
        return this.y > 3 ? this.point.name : null;
			},
			y: -4,
			x: -5,
			color: '#222',
			style: {
        font: '12px Trebuchet MS, Verdana, sans-serif',
        fontWight: 'bold'
			}
		}
	}]
};

(function($){
  var custom_count = 0,
      standard = [];

  function process(r){
    for (var i = r.length - 1; i >= 0; i--){
      r[i].original_id == 0 ? standard.push({name:r[i].name, y:r[i].count}) : custom_count += r[i].count;
    };

    if(custom_count > 0) standard.push({name:'Custom', y: custom_count});

    options.series[0].data = standard;

    new Highcharts.Chart(options);             
  
  }
  $(document).ready(function(){
    if($('#pie').length){
      var endPoint = $('#pie').attr('data-source');
      $.ajax({
        url: endPoint,
        dataType: 'json',
        success: function(r){
          process(r);      
        }
      });
    }
  });        
})(jQuery);

