class Cinstances::CinstanceCancellationEvent < ApplicationRelatedEvent

  class << self

    def create(cinstance)
      plan     = cinstance.plan
      service  = cinstance.issuer
      account  = cinstance.account
      provider = cinstance.try!(:provider_account) || account.try!(:provider_account)

      new(
        cinstance_name: cinstance.name,
        plan_name:      plan.name,
        plan_id:        cinstance.plan_id,
        service_name:   service.name,
        account_name:   account.name,
        provider:       provider,
        service:        service,
        metadata: {
          provider_id: provider.try!(:id) || cinstance.tenant_id
        }
      )
    end

    def valid?(cinstance)
      return false if cinstance.try!(:destroyed_by_association)

      cinstance && cinstance.issuer && cinstance.plan && cinstance.account
    end
  end
end
