class SsoAuthorization < ActiveRecord::Base
  attr_readonly :uid, :authentication_provider_id, :user_id

  belongs_to :user, inverse_of: :sso_authorizations
  belongs_to :authentication_provider, inverse_of: :sso_authorizations

  validates :uid, :authentication_provider, :user, presence: true
  validates :uid, uniqueness: { scope: :authentication_provider_id }
end
