class OauthFlowPresenter

  # @param [AuthenticationProvider] authentication_provider
  # @param [ActionDispatch::Request] request
  def initialize(authentication_provider, request)
    account = authentication_provider.callback_account
    @domain = authentication_provider.account.domain
    @authentication_kind = authentication_provider.read_attribute(:kind)

    domain_parameters = account.domain == @domain ? {} : { domain: @domain }
    @query_parameters = request.query_parameters.merge(domain_parameters)

    @client   = ThreeScale::OAuth2::Client.build(authentication_provider)
    @client.client.connection.ssl.verify = authentication_provider.ssl_verify_mode
    @base_url = ThreeScale::Domain.callback_endpoint(request, account, account.domain)
  end

  # Auth0 has different callback url(s) as it does not support wildcards
  # they have to be shown all together in order to save them in Auth0 client settings
  def sso_integration_callback_url
    case authentication_kind
    when 'auth0'.freeze
      # e.g. http://alaska.com/auth/auth0_123abc/callback
      # e.g. http://alaska.com/auth/invitations/auth0/auth0_123abc/callback
      regular_signup    = client.callback_url(base_url)
      invitation_signup = client.callback_url("#{base_url}/invitations")

      [regular_signup, invitation_signup].join(', ')
    else
      # e.g. http://alaska.com/auth
      base_url
    end
  end

  def callback_url
    client.callback_url(base_url, query_parameters)
  end

  def authorize_url
    client.authorize_url(base_url, query_parameters)
  end

  private

  attr_reader :client, :base_url, :query_parameters, :authentication_kind
end
