Ability.define do |user|

  if user && user.member? && user.account.master?

    if user.has_permission?(:finance)

      can :admin, :finance

      if user.account.settings.finance.allowed?
        can [:read, :update], Finance::BillingStrategy, account_id: user.account.id
        can :manage, Invoice, provider_account_id: user.account.id

        if user.account.billing_strategy.charging_enabled?
          can :manage, :charging
        end
      end
    end

  end
end
