Dir[File.join(Rails.root, 'app', 'jobs', '*.rb')].each { |file| require file }

System::Application.config.after_initialize do
  Resque.redis = System.redis
end
# don't fail retried jobs
require 'resque-retry'
require 'resque-retry/server'
require 'resque/failure/redis'

if defined?(Airbrake)
  require 'resque/failure/airbrake'
end

multiple_suppression_classes = [Resque::Failure::Redis]
multiple_suppression_classes.push(Resque::Failure::Airbrake) if defined?(Airbrake)

Resque::Failure::MultipleWithRetrySuppression.classes = multiple_suppression_classes
Resque::Failure.backend = Resque::Failure::MultipleWithRetrySuppression

config = System::Application.config.resque

Resque.logger = MonoLogger.new(config.log_path)
Resque.logger.level = MonoLogger.const_get(config.log_level.to_s.upcase)

Resque::Plugin.lint(ThreeScale::Analytics::ResquePlugin)
