Feature: Proxy integration
  In order to integrate with 3scale via a on-premise proxy
  As a provider
  I want to download config files from the inteface

  Background:
    Given a provider "foo.example.com"
    And a default service of provider "foo.example.com" has name "one"
    And the service "one" of provider "foo.example.com" has deployment option "on_premise"
    And current domain is the admin domain of provider "foo.example.com"
    And I log in as provider "foo.example.com"
    And RollingUpdates is enabled

  Scenario: Download Nginx Config without public base URL
    When I go to the integration page for service "one"
    And I follow "Download the NGINX Config files"
    Then I should be offered to download an "application/zip" file

  # regression for http://3scale.airbrake.io/errors/54042831
  Scenario: Download Nginx Config
    When I go to the integration page for service "one"
    And I fill in "proxy_endpoint" with "http://public.example.com"
    And I press "Update Production Configuration"
    And I follow "Download the NGINX Config files"
    Then I should be offered to download an "application/zip" file

  Scenario: Sandbox testing enabled by default
    When I go to the integration page for service "one"
    Then I should see button to "Test"

  Scenario: Sandbox disabled for oauth
    When provider "foo.example.com" uses backend oauth in his default service
    And I go to the integration page for service "one"
    Then I should see button to "Update Staging Configuration"

  Scenario: Download Nginx Config for oauth
    When provider "foo.example.com" uses backend oauth in his default service
    When I go to the integration page for service "one"
    And I fill in "proxy_endpoint" with "http://public.example.com"
    And I press "Update Production Configuration"
    And I follow "Download the NGINX Config files"
    Then I should be offered to download an "application/zip" file

  Scenario: Redirect url with rolling updates
    When RollingUpdates is enabled
    And I go to the integration page for service "one"
    Then I should not see "Redirect"

    When RollingUpdates is disabled
    And I go to the integration page for service "one"
    Then I should see "Redirect"

  Scenario: Edit endpoint with proxy_pro
    Given all the rolling updates features are off
    When I have proxy_pro feature enabled
     And I have async_apicast_deploy feature enabled
    Then I can edit the proxy public endpoint

  @javascript
  Scenario: Restore to default API Backend
    Given I'm using a custom API Backend
    Then I should be able to switch back to using the default API Backend
