@javascript @audit
Feature: Signup
  In order to use 3scale API management infrastructure
  As a wanna-be API provider
  I want to sign up

Background:
  Given provider "master" has multiple applications disabled
    And provider "master" has default service and account plan
  Given a default application plan "Base" of provider "master"

@ignore-backend @allow-rescue
Scenario: Signup, activate, login, create sample data and let a buyer login
  Given current domain is the admin domain of provider "master"
    And master provider has the following fields defined for "Account":
    | name                 | required | read_only | hidden |
    | API_Status_3s__c     |          |           |        |
    | API_Purpose_3s__c    |          |           |        |
    | API_Type_3s__c       |          |           |        |
   When I go to the provider sign up page
   And I fill in the following:
     | Email                   | tom@monsterapi.com |
     | First name              | quentin            |
     | Organization/Group Name | foo                |
     | Password                | godzilla           |
   And I press "Sign up"
   Then I should see "Hi quentin, thank you for signing up"
   And the domain of provider "foo" should be "foo.3scale.net"
   And the admin domain of provider "foo" should be "foo-admin.3scale.net"

    And provider "foo" has all the templates setup
   # --- Otherwise sample data will fail --- because it runs in different process and we cannot stub backend calls
   And the service of provider "foo" has "mandatory_app_key" set to "false"

  # --- Provider logs in ---
  When the current domain is foo-admin.3scale.net
  When I follow the activation link in an email sent to "tom@monsterapi.com"
   And I fill in the following:
    | Email or Username | tom@monsterapi.com |
    | Password          | godzilla           |
   And I press "Sign in"
  Then I should be logged in as "admin"
  And I should be on the provider onboarding wizard page

  # TODO: since this generates request to our system, we have to fake it :/ ... trust me
  #  When I follow "Create Sample Data"
  #  Then I should see "Sample Data created"
  When provider "foo" creates sample data
  #Then provider "foo" should have sample data

  # TODO: this should be redone once we have new sample plans
  # so I'm leting it fail as a reminder
  And I go to the application plans admin page
  Then I should see "Unlimited"

  # --- 3scaleadmin user cannot log in ---
  When I follow "Account and Personal Settings"
  Then I follow "Sign Out"
   And I fill in the following:
    | Email or Username | 3scaleadmin |
    | Password          | 1llacuna62  |
   And I press "Sign in"
  Then I should not be logged in as "3scaleadmin"

  # --- Buyer signs up ---
  Given the current domain is foo.3scale.net
    And provider "foo" has site access code "foobar"
   When I go to the sign up page
    And I enter "foobar" as access code
    And I fill in the following:
     | Username                | bob                   |
     | Email                   | bob@customer.net      |
     | Organization/Group Name | bob's enterprise      |
     | Password                | ie4ever               |
     | Password confirmation   | ie4ever               |
    And I press "Sign up"
    And I wait a moment
   Then I should see "Thank you"

  # --- Buyer logs in ---
  When I follow the activation link in an email sent to "bob@customer.net"
  And I fill in the following:
    | Username or Email | bob     |
    | Password          | ie4ever |
  And I press "Sign in"
  Then I should be on the homepage
  # --- Sample Users logs in ---
  Then I follow "Logout"
  And I follow "Sign in"
  And I fill in the following:
  | Username or Email |   john |
  | Password          | 123456 |
  And I press "Sign in"
  Then I should be on the homepage

Scenario: Custom portal and admin sub-domains
  Given current domain is the admin domain of provider "master"
  Given I go to the provider sign up page
  And I fill in the following:
    | Developer Portal       | hello-monster      |
  Then I should see a correct and un-editable admin portal subdomain

