When(/^on the response codes chart page$/) do
  visit admin_service_stats_response_codes_path(@provider.first_service!)
end

RESPONSE_CODES = %w[2XX 4XX 5XX].freeze
RESPONSE_CODE_VALUE = 10

Given(/^the provider has response codes stats data$/) do
  storage = Stats::Client.storage
  now = Time.now.utc
  service = @provider.first_service!

  keys = RESPONSE_CODES.flat_map do |code|
    [["stats/{service:#{service.id}}/response_code:#{code}/hour:#{now.at_beginning_of_day.to_s(:compact)}", RESPONSE_CODE_VALUE]]
  end.to_h

  storage.mapped_mset(keys)
end

Given(/^the provider has cubert request logs feature (enabled|disabled)$/) do |enabled|
  step 'all the rolling updates features are off'

  Stats::ResponseCodesController.any_instance.expects(:provider_can_use_cubert_request_logs?).returns(enabled == 'enabled' ).at_least_once
end

Then(/^there should be a request logs section$/) do
  page.should have_css('#request-logs')
end

Then(/^there should not be a request logs section$/) do
  page.should_not have_css('#request-logs')
end
