module System
  module ErrorReporting
    module_function

    def report_error(exception, context = nil)
      options = context ? {parameters: context} : {}

      ::Airbrake.notify_or_ignore(exception, options) if defined?(Airbrake)
      ::Bugsnag.notify_or_ignore(exception)
      ::NewRelic::Agent.notice_error(exception) if defined?(::NewRelic)
    end
  end
end
