namespace :cubert do
  desc "Populate cubert with sample data"
  task populate: :environment do
    next if CubertRequestLogsService.disabled?
    service = Service.find(6)


    cubert_info = service.cubert_info || service.create_cubert_info
    cubert_info.bucket_id = CubertRequestLogsService.new('foo').send(:connection).create_bucket.id
    cubert_info.save

    crls = CubertRequestLogsService.new(cubert_info)

    logs = []
    app_ids = service.cinstances.limit(100).map(&:application_id)
    codes = [200, 202, 300, 3001, 302, 400, 401, 402, 404, 500, 501, 503, 42, 69, 666]
    metrics = ['hits', 'mb_consumed', 'account', 'analytics', 'stats', 'service']
    request = {"path"=>"/stats/applications/1409611704405/usage.json?provider_key=23225ff0423c9754aba6b2d5df01447b&metric_name=hits&since=2015-01-18&period=month&until=2015-03-19&granularity=month", "method"=>"GET", "remote_ip"=>"45.56.108.242", "headers"=>{"HTTP_VERSION"=>"HTTP/1.0", "HTTP_X_FORWARDED_FOR"=>"45.56.108.242, 45.56.108.242", "HTTP_X_REAL_IP"=>"45.56.108.242", "HTTP_X_REQUEST_START"=>"t=1426779639.571", "HTTP_HOST"=>"similargroup-admin.3scale.net", "HTTP_CONNECTION"=>"close", "HTTP_ACCEPT"=>"*/*", "HTTP_COOKIE"=>"_system_session=BAh7BkkiD3Nlc3Npb25faWQGOgZFVEkiJThmYWNjOGEzMmExNjdlOWUzMDJhMWI0NDlmNmNiYTIyBjsAVA%3D%3D--f21e23a12d55a316ccbbe53eebfd36b388e68d9d", "HTTP_REFERER"=>"", "HTTP_USER_AGENT"=>"Curl/PHP 5.5.9-1ubuntu4.6 (http://github.com/shuber/curl/)", "HTTP_X_FORWARDED_PORT"=>"443", "HTTP_X_FORWARDED_PROTO"=>"https"}}

    100.times do
      timestamp = Time.now + rand(1_000_000)
      usage = metrics.sample((rand(5))).map { |metric| "#{metric}: #{rand(10)}" }
      logs << {
        service_id: service.id,
        application_id: app_ids.sample,
        usage: usage.join(", "),
        timestamp: timestamp,
        log: { request: request, response: request, code: codes.sample }
      }
    end

    crls.store_logs logs
  end
end
