(function() {
  var create_glower, create_intro_tabs;

  create_glower = function(trigger, selector) {
    return $(trigger).hover(function() {
      return $(selector).toggleClass('glowing');
    });
  };

  create_intro_tabs = function() {
    var err, hashLocationString, i, id, j, len, page, ref, tab, tab_ids, title;
    tab_ids = [];
    ref = $('#cms-intro-tabs div.cms-intro-page');
    for (i = j = 0, len = ref.length; j < len; i = ++j) {
      page = ref[i];
      id = $(page).attr('id');
      title = $(page).data('title');
      tab_ids.push(id);
      $(page).data('ui-tabs-index', i);
      $('#cms-intro-tabs > ul').append("<li><a href='#" + id + "'>" + title + "</a></li>");
    }
    hashLocationString = window.location.hash.replace('#', '');
    if ($.inArray(hashLocationString, tab_ids) >= 0) {
      tab = hashLocationString;
    } else if ($.inArray($.cookie('getting-started-tabs'), tab_ids) >= 0) {
      tab = $.cookie('getting-started-tabs');
    } else {
      tab = tab_ids[0];
    }
    try {
      return $('#cms-intro-tabs').tabs({
        active: $("#cms-intro-tabs > #" + tab).data('ui-tabs-index'),
        activate: function(event, ui) {
          var currentTab;
          currentTab = ui.newPanel.selector.slice(1);
          $.cookie('getting-started-tabs', currentTab);
          return window.setLocationHash(currentTab);
        }
      });
    } catch (_error) {
      err = _error;
      return console.log(tab + " isn't a valid css selector");
    }
  };

  $(document).ready(function() {
    if ($('#cms-intro-tabs').length > 0) {
      create_glower("#filter-glow", "#cms-filter input");
      create_glower("#type-glow", "#cms-sidebar-filter-type li");
      create_glower("#origin-glow", "#cms-sidebar-filter-origin li");
      create_glower("#partials-glow", '#cms-sidebar-filter-type li[data-filter-type="partial"]');
      create_glower("#layouts-glow", '#cms-sidebar-filter-type li[data-filter-type="layout"]');
      return create_intro_tabs();
    }
  });

}).call(this);
