// https://code.djangoproject.com/browser/django/trunk/django/contrib/admin/static/admin/js/urlify.js?rev=17914

(function(window) {
  var LATIN_MAP = {
      'À': 'A', 'Á': 'A', 'Â': 'A', 'Ã': 'A', 'Ä': 'A', 'Å': 'A', 'Æ': 'AE', 'Ç':
      'C', 'È': 'E', 'É': 'E', 'Ê': 'E', 'Ë': 'E', 'Ì': 'I', 'Í': 'I', 'Î': 'I',
      'Ï': 'I', 'Ð': 'D', 'Ñ': 'N', 'Ò': 'O', 'Ó': 'O', 'Ô': 'O', 'Õ': 'O', 'Ö':
      'O', 'Ő': 'O', 'Ø': 'O', 'Ù': 'U', 'Ú': 'U', 'Û': 'U', 'Ü': 'U', 'Ű': 'U',
      'Ý': 'Y', 'Þ': 'TH', 'ß': 'ss', 'à':'a', 'á':'a', 'â': 'a', 'ã': 'a', 'ä':
      'a', 'å': 'a', 'æ': 'ae', 'ç': 'c', 'è': 'e', 'é': 'e', 'ê': 'e', 'ë': 'e',
      'ì': 'i', 'í': 'i', 'î': 'i', 'ï': 'i', 'ð': 'd', 'ñ': 'n', 'ò': 'o', 'ó':
      'o', 'ô': 'o', 'õ': 'o', 'ö': 'o', 'ő': 'o', 'ø': 'o', 'ù': 'u', 'ú': 'u',
      'û': 'u', 'ü': 'u', 'ű': 'u', 'ý': 'y', 'þ': 'th', 'ÿ': 'y'
  }
  var LATIN_SYMBOLS_MAP = {
      '©':'(c)'
  }
  var GREEK_MAP = {
      'α':'a', 'β':'b', 'γ':'g', 'δ':'d', 'ε':'e', 'ζ':'z', 'η':'h', 'θ':'8',
      'ι':'i', 'κ':'k', 'λ':'l', 'μ':'m', 'ν':'n', 'ξ':'3', 'ο':'o', 'π':'p',
      'ρ':'r', 'σ':'s', 'τ':'t', 'υ':'y', 'φ':'f', 'χ':'x', 'ψ':'ps', 'ω':'w',
      'ά':'a', 'έ':'e', 'ί':'i', 'ό':'o', 'ύ':'y', 'ή':'h', 'ώ':'w', 'ς':'s',
      'ϊ':'i', 'ΰ':'y', 'ϋ':'y', 'ΐ':'i',
      'Α':'A', 'Β':'B', 'Γ':'G', 'Δ':'D', 'Ε':'E', 'Ζ':'Z', 'Η':'H', 'Θ':'8',
      'Ι':'I', 'Κ':'K', 'Λ':'L', 'Μ':'M', 'Ν':'N', 'Ξ':'3', 'Ο':'O', 'Π':'P',
      'Ρ':'R', 'Σ':'S', 'Τ':'T', 'Υ':'Y', 'Φ':'F', 'Χ':'X', 'Ψ':'PS', 'Ω':'W',
      'Ά':'A', 'Έ':'E', 'Ί':'I', 'Ό':'O', 'Ύ':'Y', 'Ή':'H', 'Ώ':'W', 'Ϊ':'I',
      'Ϋ':'Y'
  }
  var TURKISH_MAP = {
      'ş':'s', 'Ş':'S', 'ı':'i', 'İ':'I', 'ç':'c', 'Ç':'C', 'ü':'u', 'Ü':'U',
      'ö':'o', 'Ö':'O', 'ğ':'g', 'Ğ':'G'
  }
  var RUSSIAN_MAP = {
      'а':'a', 'б':'b', 'в':'v', 'г':'g', 'д':'d', 'е':'e', 'ё':'yo', 'ж':'zh',
      'з':'z', 'и':'i', 'й':'j', 'к':'k', 'л':'l', 'м':'m', 'н':'n', 'о':'o',
      'п':'p', 'р':'r', 'с':'s', 'т':'t', 'у':'u', 'ф':'f', 'х':'h', 'ц':'c',
      'ч':'ch', 'ш':'sh', 'щ':'sh', 'ъ':'', 'ы':'y', 'ь':'', 'э':'e', 'ю':'yu',
      'я':'ya',
      'А':'A', 'Б':'B', 'В':'V', 'Г':'G', 'Д':'D', 'Е':'E', 'Ё':'Yo', 'Ж':'Zh',
      'З':'Z', 'И':'I', 'Й':'J', 'К':'K', 'Л':'L', 'М':'M', 'Н':'N', 'О':'O',
      'П':'P', 'Р':'R', 'С':'S', 'Т':'T', 'У':'U', 'Ф':'F', 'Х':'H', 'Ц':'C',
      'Ч':'Ch', 'Ш':'Sh', 'Щ':'Sh', 'Ъ':'', 'Ы':'Y', 'Ь':'', 'Э':'E', 'Ю':'Yu',
      'Я':'Ya'
  }
  var UKRAINIAN_MAP = {
      'Є':'Ye', 'І':'I', 'Ї':'Yi', 'Ґ':'G', 'є':'ye', 'і':'i', 'ї':'yi', 'ґ':'g'
  }
  var CZECH_MAP = {
      'č':'c', 'ď':'d', 'ě':'e', 'ň': 'n', 'ř':'r', 'š':'s', 'ť':'t', 'ů':'u',
      'ž':'z', 'Č':'C', 'Ď':'D', 'Ě':'E', 'Ň': 'N', 'Ř':'R', 'Š':'S', 'Ť':'T',
      'Ů':'U', 'Ž':'Z'
  }

  var POLISH_MAP = {
      'ą':'a', 'ć':'c', 'ę':'e', 'ł':'l', 'ń':'n', 'ó':'o', 'ś':'s', 'ź':'z',
      'ż':'z', 'Ą':'A', 'Ć':'C', 'Ę':'e', 'Ł':'L', 'Ń':'N', 'Ó':'o', 'Ś':'S',
      'Ź':'Z', 'Ż':'Z'
  }

  var LATVIAN_MAP = {
      'ā':'a', 'č':'c', 'ē':'e', 'ģ':'g', 'ī':'i', 'ķ':'k', 'ļ':'l', 'ņ':'n',
      'š':'s', 'ū':'u', 'ž':'z', 'Ā':'A', 'Č':'C', 'Ē':'E', 'Ģ':'G', 'Ī':'i',
      'Ķ':'k', 'Ļ':'L', 'Ņ':'N', 'Š':'S', 'Ū':'u', 'Ž':'Z'
  }

  var ALL_DOWNCODE_MAPS=new Array()
  ALL_DOWNCODE_MAPS[0]=LATIN_MAP
  ALL_DOWNCODE_MAPS[1]=LATIN_SYMBOLS_MAP
  ALL_DOWNCODE_MAPS[2]=GREEK_MAP
  ALL_DOWNCODE_MAPS[3]=TURKISH_MAP
  ALL_DOWNCODE_MAPS[4]=RUSSIAN_MAP
  ALL_DOWNCODE_MAPS[5]=UKRAINIAN_MAP
  ALL_DOWNCODE_MAPS[6]=CZECH_MAP
  ALL_DOWNCODE_MAPS[7]=POLISH_MAP
  ALL_DOWNCODE_MAPS[8]=LATVIAN_MAP

  var Downcoder = new Object();
  Downcoder.Initialize = function()
  {
      if (Downcoder.map) // already made
          return ;
      Downcoder.map ={}
      Downcoder.chars = '' ;
      for(var i in ALL_DOWNCODE_MAPS)
      {
          var lookup = ALL_DOWNCODE_MAPS[i]
          for (var c in lookup)
          {
              Downcoder.map[c] = lookup[c] ;
              Downcoder.chars += c ;
          }
       }
      Downcoder.regex = new RegExp('[' + Downcoder.chars + ']|[^' + Downcoder.chars + ']+','g') ;
  }

  downcode= function( slug )
  {
      Downcoder.Initialize() ;
      var downcoded =""
      var pieces = slug.match(Downcoder.regex);
      if(pieces)
      {
          for (var i = 0 ; i < pieces.length ; i++)
          {
              if (pieces[i].length == 1)
              {
                  var mapped = Downcoder.map[pieces[i]] ;
                  if (mapped != null)
                  {
                      downcoded+=mapped;
                      continue ;
                  }
              }
              downcoded+=pieces[i];
          }
      }
      else
      {
          downcoded = slug;
      }
      return downcoded;
  }


  function URLify(s, num_chars) {
      // changes, e.g., "Petty theft" to "petty_theft"
      // remove all these words from the string before urlifying
      s = downcode(s);
      removelist = ["a", "an", "as", "at", "before", "but", "by", "for", "from",
                    "is", "in", "into", "like", "of", "off", "on", "onto", "per",
                    "since", "than", "the", "this", "that", "to", "up", "via",
                    "with"];
      r = new RegExp('\\b(' + removelist.join('|') + ')\\b', 'gi');
      s = s.replace(r, '');
      // if downcode doesn't hit, the char will be stripped here
      s = s.replace(/[^-\w\s]/g, '');  // remove unneeded chars
      s = s.replace(/^\s+|\s+$/g, ''); // trim leading/trailing spaces
      s = s.replace(/[-\s]+/g, '-');   // convert spaces to hyphens
      s = s.toLowerCase();             // convert to lowercase
      return s.substring(0, num_chars);// trim to first num_chars chars
  }

  window.URLify = URLify;
})(window);
//
// Mailgun Address Validation Plugin
//
// Attaching to a form:
//
//    $('jquery_selector').mailgun_validator({
//        api_key: 'api-key',
//        in_progress: in_progress_callback, // called when request is made to validator
//        success: success_callback,         // called when validator has returned
//        error: validation_error,           // called when an error reaching the validator has occured
//    });
//
//
// Sample JSON in success callback:
//
//  {
//      "is_valid": true,
//      "parts": {
//          "local_part": "john.smith@example.com",
//          "domain": "example.com",
//          "display_name": ""
//      },
//      "address": "john.smith@example.com",
//      "did_you_mean": null
//  }
//
// More API details: https://api.mailgun.net/v2/address
//


$.fn.mailgun_validator = function(options) {
    return this.each(function() {
        $(this).focusout(function() {
            run_validator($(this).val(), options);
        });
    });
};


function run_validator(address_text, options) {
    // don't run validator without input
    if (!address_text) {
        return;
    }

    // length check
    if (address_text.length > 512) {
        error_message = 'Stream exceeds maxiumum allowable length of 512.';
        if (options && options.error) {
            options.error(error_message);
        }
        else {
            console.log(error_message);
        }
        return;
    }

    // validator is in progress
    if (options && options.in_progress) {
        options.in_progress();
    }

    // require api key
    if (options && options.api_key == undefined) {
        console.log('Please pass in api_key to mailgun_validator.')
    }

    var success = false;

    // make ajax call to get validation results
    $.ajax({
        type: "GET",
        url: 'https://api.mailgun.net/v2/address/validate?callback=?',
        // 3scale change, we added syntax_only false to enable DNS validation
        data: { address: address_text, api_key: options.api_key, syntax_only: false },
        dataType: "jsonp",
        crossDomain: true,
        success: function(data, status_text) {
            success = true;
            if (options && options.success) {
                options.success(data);
            }
        },
        error: function(request, status_text, error) {
            success = true;
            error_message = 'Error occurred, unable to validate address.';

            if (options && options.error) {
                options.error(error_message);
            }
            else {
                console.log(error_message);
            }
        }
    });

    // timeout incase of some kind of internal server error
    setTimeout(function() {
        error_message = 'Error occurred, unable to validate address.';
        if (!success) {
            if (options && options.error) {
                options.error(error_message);
            }
            else {
                console.log(error_message);
            }
        }
    }, 30000);

}
;
// from https://raw.github.com/MartinMartimeo/tipsy/master/src/javascripts/jquery.tipsy.js
// tipsy, facebook style tooltips for jquery
// version 1.0.0a
// (c) 2008-2010 jason frame [jason@onehackoranother.com]
// released under the MIT license

(function($) {

  function maybeCall(thing, ctx) {
    return (typeof thing == 'function') ? (thing.call(ctx)) : thing;
  }

  function isElementInDOM(ele) {
    while (ele = ele.parentNode) {
      if (ele == document) return true;
    }
    return false;
  }

  var tipsyIDcounter = 0;
  function tipsyID() {
    return "tipsyuid" + (tipsyIDcounter++);
  }

  function Tipsy(element, options) {
    this.$element = $(element);
    this.options = options;
    this.enabled = true;
    this.fixTitle();
  }

  Tipsy.prototype = {
    show: function() {
      if (!isElementInDOM(this.$element[0])) {
        return;
      }

      if (this.$element instanceof HTMLElement && !this.$element.is(':visible')) {
        return;
      }

      var title;
      if (this.enabled && (title = this.getTitle())) {
        var $tip = this.tip();

        $tip.find('.tipsy-inner' + this.options.theme)[this.options.html ? 'html' : 'text'](title);

        $tip[0].className = 'tipsy' + this.options.theme; // reset classname in case of dynamic gravity
        if (this.options.className) {
          $tip.addClass(maybeCall(this.options.className, this.$element[0]));
        }

        $tip.remove().css({top: 0, left: 0, visibility: 'hidden', display: 'block'}).prependTo(document.body);

        var pos = $.extend({}, this.$element.offset());

        // If the element is contained in a SVG object, use getBBox
        if (this.$element.parents('svg').size() > 0) {
          pos = $.extend(pos, this.$element[0].getBBox());
        } else {
          pos = $.extend(pos, {
            width: this.$element[0].offsetWidth || 0,
            height: this.$element[0].offsetHeight || 0
          });
        }

        var actualWidth = $tip[0].offsetWidth,
          actualHeight = $tip[0].offsetHeight,
          gravity = maybeCall(this.options.gravity, this.$element[0]);

        var tp;
        switch (gravity.charAt(0)) {
          case 'n':
            tp = {top: pos.top + pos.height + this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
            break;
          case 's':
            tp = {top: pos.top - actualHeight - this.options.offset, left: pos.left + pos.width / 2 - actualWidth / 2};
            break;
          case 'e':
            tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left - actualWidth - this.options.offset};
            break;
          case 'w':
            tp = {top: pos.top + pos.height / 2 - actualHeight / 2, left: pos.left + pos.width + this.options.offset};
            break;
          default:
            break;
        }

        if (gravity.length == 2) {
          if (gravity.charAt(1) == 'w') {
            tp.left = pos.left + pos.width / 2 - 15;
          } else {
            tp.left = pos.left + pos.width / 2 - actualWidth + 15;
          }
        }

        $tip.css(tp).addClass('tipsy-' + gravity + this.options.theme);
        $tip.find('.tipsy-arrow' + this.options.theme)[0].className = 'tipsy-arrow' + this.options.theme + ' tipsy-arrow-' + gravity.charAt(0) + this.options.theme;

        if (this.options.fade) {
          if(this.options.shadow)
            $(".tipsy-inner").css({'box-shadow': '0px 0px '+this.options.shadowBlur+'px '+this.options.shadowSpread+'px rgba(0, 0, 0, '+this.options.shadowOpacity+')', '-webkit-box-shadow': '0px 0px '+this.options.shadowBlur+'px '+this.options.shadowSpread+'px rgba(0, 0, 0, '+this.options.shadowOpacity+')'});
          $tip.stop().css({opacity: 0, display: 'block', visibility: 'visible'}).animate({opacity: this.options.opacity});
        } else {
          $tip.css({visibility: 'visible', opacity: this.options.opacity});
        }

        if (this.options.aria) {
          var $tipID = tipsyID();
          $tip.attr("id", $tipID);
          this.$element.attr("aria-describedby", $tipID);
        }
      }
    },

    hide: function() {
      if (this.options.fade) {
        this.tip().stop().fadeOut(function() { $(this).remove(); });
      } else {
        this.tip().remove();
      }
      if (this.options.aria) {
        this.$element.removeAttr("aria-describedby");
      }
    },

    fixTitle: function() {
      var $e = this.$element;
      if ($e.prop('title') || typeof($e.prop('original-title')) != 'string') {
        $e.prop('original-title', $e.prop('title') || '').removeAttr('title');
      }
    },

    getTitle: function() {
      var title, $e = this.$element, o = this.options;
      this.fixTitle();
      if (typeof o.title == 'string') {
        title = $e.prop(o.title == 'title' ? 'original-title' : o.title);
      } else if (typeof o.title == 'function') {
        title = o.title.call($e[0]);
      }
      title = ('' + title).replace(/(^\s*|\s*$)/, "");
      return title || o.fallback;
    },

    tip: function() {
      if (!this.$tip) {
        this.$tip = $('<div class="tipsy' + this.options.theme + '"></div>').html('<div class="tipsy-arrow' + this.options.theme + '"></div><div class="tipsy-inner' + this.options.theme + '"></div>').attr("role","tooltip");
        this.$tip.data('tipsy-pointee', this.$element[0]);
      }
      return this.$tip;
    },

    validate: function() {
      if (!this.$element[0].parentNode) {
        this.hide();
        this.$element = null;
        this.options = null;
      }
    },

    enable: function() { this.enabled = true; },
    disable: function() { this.enabled = false; },
    toggleEnabled: function() { this.enabled = !this.enabled; }
  };

  $.fn.tipsy = function(options) {

    $.fn.tipsy.enable();

    if (options === true) {
      return this.data('tipsy');
    } else if (typeof options == 'string') {
      var tipsy = this.data('tipsy');
      if (tipsy) tipsy[options]();
      return this;
    }

    options = $.extend({}, $.fn.tipsy.defaults, options);

    // Establish theme
    options.theme = (options.theme && options.theme !== '') ? '-' + options.theme : '';

    function get(ele) {
      var tipsy = $.data(ele, 'tipsy');
      if (!tipsy) {
        tipsy = new Tipsy(ele, $.fn.tipsy.elementOptions(ele, options));
        $.data(ele, 'tipsy', tipsy);
      }
      return tipsy;
    }

    function enter() {
      if ($.fn.tipsy.enabled !== true) {
        return;
      }
      var tipsy = get(this);
      tipsy.hoverState = 'in';
      if (options.delayIn === 0) {
        tipsy.show();
      } else {
        tipsy.fixTitle();
        setTimeout(function() {
          if (tipsy.hoverState == 'in' && isElementInDOM(tipsy.$element)) {
            tipsy.show();
          }
        }, options.delayIn);
      }
    }

    function leave() {
      var tipsy = get(this);
      tipsy.hoverState = 'out';
      if (options.delayOut === 0) {
        tipsy.hide();
      } else {
        setTimeout(function() { if (tipsy.hoverState == 'out' || !tipsy.$element || !tipsy.$element.is(':visible')) tipsy.hide(); }, options.delayOut);
      }
    }

    if (!options.live) this.each(function() { get(this); });

    if (options.trigger != 'manual') {
      var eventIn  = options.trigger == 'hover' ? 'mouseenter mouseover' : 'focus',
        eventOut = options.trigger == 'hover' ? 'mouseleave mouseout' : 'blur';

      if (options.live && options.live !== true) {
        $(this).on(eventIn, options.live, enter);
        $(this).on(eventOut, options.live, leave);
      } else {
        if (options.live && !$.live) {
          //live === true and using jQuery >= 1.9
          throw "Since jQuery 1.9, pass selector as live argument. eg. $(document).tipsy({live: 'a.live'});";
        }
        var binder = options.live ? 'live' : 'bind';
        this[binder](eventIn, enter)[binder](eventOut, leave);
      }
    }

    return this;

  };

  $.fn.tipsy.defaults = {
    aria: false,
    className: null,
    delayIn: 0,
    delayOut: 0,
    fade: false,
    shadow: false,
    shadowBlur: 8,
    shadowOpacity: 1,
    shadowSpread: 0,
    fallback: '',
    gravity: 'n',
    html: false,
    live: false,
    offset: 0,
    opacity: 0.8,
    title: 'title',
    trigger: 'hover',
    theme: ''
  };

  $.fn.tipsy.revalidate = function() {
    $('.tipsy').each(function() {
      var pointee = $.data(this, 'tipsy-pointee');
      if (!pointee || !isElementInDOM(pointee)) {
        $(this).remove();
      }
    });
  };

  $.fn.tipsy.enable = function() {
    $.fn.tipsy.enabled = true;
  };

  $.fn.tipsy.disable = function() {
    $.fn.tipsy.enabled = false;
  };

  // Overwrite this method to provide options on a per-element basis.
  // For example, you could store the gravity in a 'tipsy-gravity' attribute:
  // return $.extend({}, options, {gravity: $(ele).prop('tipsy-gravity') || 'n' });
  // (remember - do not modify 'options' in place!)
  $.fn.tipsy.elementOptions = function(ele, options) {
    return $.metadata ? $.extend({}, options, $(ele).metadata()) : options;
  };

  $.fn.tipsy.autoNS = function() {
    return $(this).offset().top > ($(document).scrollTop() + $(window).height() / 2) ? 's' : 'n';
  };

  $.fn.tipsy.autoWE = function() {
    return $(this).offset().left > ($(document).scrollLeft() + $(window).width() / 2) ? 'e' : 'w';
  };

  $.fn.tipsy.autoNWNE = function() {
    return $(this).offset().left > ($(document).scrollLeft() + $(window).width() / 2) ? 'ne' : 'nw';
  };

  $.fn.tipsy.autoSWSE = function() {
    return $(this).offset().left > ($(document).scrollLeft() + $(window).width() / 2) ? 'se' : 'sw';
  };

  /**
   * yields a closure of the supplied parameters, producing a function that takes
   * no arguments and is suitable for use as an autogravity function like so:
   *
   * @param margin (int) - distance from the viewable region edge that an
   *        element should be before setting its tooltip's gravity to be away
   *        from that edge.
   * @param prefer (string, e.g. 'n', 'sw', 'w') - the direction to prefer
   *        if there are no viewable region edges effecting the tooltip's
   *        gravity. It will try to vary from this minimally, for example,
   *        if 'sw' is preferred and an element is near the right viewable
   *        region edge, but not the top edge, it will set the gravity for
   *        that element's tooltip to be 'se', preserving the southern
   *        component.
   */
  $.fn.tipsy.autoBounds = function(marginNorth, marginEast, prefer) {
    return function() {
      var dir = {ns: prefer[0], ew: (prefer.length > 1 ? prefer[1] : false)},
        boundTop = $(document).scrollTop() + marginNorth,
        boundLeft = $(document).scrollLeft() + marginEast,
        $this = $(this);

      if ($this.offset().top < boundTop) dir.ns = 'n';
      if ($this.offset().left < boundLeft) dir.ew = 'w';
      if ($(window).width() + $(document).scrollLeft() - $this.offset().left < marginEast) dir.ew = 'e';
      if ($(window).height() + $(document).scrollTop() - $this.offset().top < marginNorth) dir.ns = 's';

      return dir.ns + (dir.ew ? dir.ew : '');
    };
  };

})(jQuery);





(function ($) {

    $(function () {
        $('form input').tipsy({trigger: 'focus', gravity: 'w'});

        $('.signup_form :input').each(function () {
            $(this).placeholder();
        });

        var first_name = $("#account_user_first_name");
        var first_name_val = first_name.val();
        var last_name_list_item = $("#account_user_last_name_input");
        var last_name_errors = last_name_list_item.find(".inline-errors");


        if (first_name_val !== "") {
            last_name_errors.find(".first-name").html(first_name_val);
        }

        first_name.change(function (e) {
            var first_name_val = first_name.val();
            var last_name_list_item = $("#account_user_last_name_input");
            var last_name_hints = last_name_list_item.find(".inline-hints");
            var last_name_errors = last_name_list_item.find(".inline-errors");

            if (first_name_val !== "") {
                last_name_hints.find(".first-name").html(first_name_val);
                last_name_errors.find(".first-name").html(first_name_val);
            }
        });


        var domain = $("#account_subdomain");
        var self_domain = $("#account_self_subdomain");

        domain.keyup(function () {
            var val = domain.val();
            if (val !== "") {
                val += "-admin";
            }
            self_domain.val(val);
        });

        if (domain.val() === "") {
            domain.data('autoupdate', true);
        }

        domain.change(function (e) {
            if (domain.val() === "") {
                domain.data('autoupdate', true);
            } else {
                domain.data('autoupdate', false);
            }
        });

        $(document).on('keyup', '#account_org_name', function () {
            var name = $(this).val();
            var slug = window.URLify(name);
            domain.parent('li').removeClass('hidden');
            self_domain.parent('li').removeClass('hidden');

            if (domain.data('autoupdate')) {
                domain.val(slug);
                domain.trigger('keyup');
            }
        });


        //var org_name = $('#account_org_name');

        var user_email = $('#account_user_email');
        var user_email_error = $('<p class="inline-errors"></p>');
        var email_parent = user_email.parent('li');
        var previous_email_error = user_email.next(".inline-errors");

        user_email.mailgun_validator({
            api_key: 'pubkey-889234583a41faa6d99b50ae152b2a3f',
            success: function (response) {
                var error_message = '';

                user_email_error.remove();

                if (response.is_valid) {
                    email_parent.removeClass('error');
                    user_email_error.remove();
                } else {
                    email_parent.addClass('error');

                    if (response.did_you_mean) {
                        error_message = "Did you mean: " + response.did_you_mean + "?";
                    }
                    else {
                        error_message = "The email address should exist.";
                    }
                }
                previous_email_error.hide();
                user_email_error.appendTo(email_parent).text(error_message);
            },
            error: function () {
                user_email_error.remove();
            }
        })
    });
})(jQuery);
