require 'test_helper'

class DeveloperPortal::Admin::Account::Adyen12ControllerTest < DeveloperPortal::AbstractPaymentGatewaysControllerTest
  include ActiveMerchantTestHelpers
  include ActiveMerchantTestHelpers::Adyen12

  test '#show' do
    get :show
    assert_response :success
  end

  test '#hosted_success without errors' do
    # We have created a profile in '#show' so credit_card_auth_code must be present
    @account.update_attribute(:credit_card_auth_code, 'authcode')
    json = {
      'expiryMonth' => 02,
      'expiryYear' => 2017,
      'number' => 4444
    }
    ::PaymentGateways::Adyen12Crypt.any_instance.stubs(:authorize_with_encrypted_card).returns(successful_adyen_response)
    ::PaymentGateways::Adyen12Crypt.any_instance.expects(:retrieve_card_details).returns(json)

    get :hosted_success
    @account.reload

    assert_equal '2017-02-01', @account['credit_card_expires_on'].to_s
    assert_equal '4444', @account.credit_card_partial_number
    assert_redirected_to '/admin/account/adyen12'
  end

  test '#hosted_success with errors in authorize' do
    # We have created a profile in '#show' so credit_card_auth_code must be present
    @account.update_attribute(:credit_card_auth_code, 'authcode')

    ::PaymentGateways::Adyen12Crypt.any_instance.stubs(:authorize_with_encrypted_card).returns(failing_adyen_response)
    ::PaymentGateways::Adyen12Crypt.any_instance.expects(:retrieve_card_details).never

    get :hosted_success
    @account.reload

    assert_nil @account['credit_card_expires_on']
    assert_nil @account.credit_card_partial_number
    assert_redirected_to '/admin/account/adyen12'
  end

  test '#hosted_success with errors in authorize with plan changes' do
    # We have created a profile in '#show' so credit_card_auth_code must be present
    @account.update_attribute(:credit_card_auth_code, 'authcode')

    ::PaymentGateways::Adyen12Crypt.any_instance.stubs(:authorize_with_encrypted_card).returns(failing_adyen_response)
    ::PaymentGateways::Adyen12Crypt.any_instance.expects(:retrieve_card_details).never
    session[:plan_changes] = {1 => 2}

    get :hosted_success
    @account.reload

    assert_nil @account['credit_card_expires_on']
    assert_nil @account.credit_card_partial_number
    assert_redirected_to '/admin/account/adyen12'
  end

  test '#hosted_success with plan changes' do
    # We have created a profile in '#show' so credit_card_auth_code must be present
    @account.update_attribute(:credit_card_auth_code, 'authcode')
    json = {
      'expiryMonth' => 02,
      'expiryYear' => 2017,
      'number' => 4444
    }
    ::PaymentGateways::Adyen12Crypt.any_instance.stubs(:authorize_with_encrypted_card).returns(successful_adyen_response)
    ::PaymentGateways::Adyen12Crypt.any_instance.expects(:retrieve_card_details).returns(json)
    session[:plan_changes] = {1 => 2}

    get :hosted_success
    @account.reload

    assert_equal '2017-02-01', @account['credit_card_expires_on'].to_s
    assert_equal '4444', @account.credit_card_partial_number
    assert_redirected_to admin_account_plan_changes_path
  end

test '#hosted_success with unconfigured gateway' do
    setting = @provider.payment_gateway_setting
    setting.gateway_settings = setting.gateway_settings.except(:merchantAccount)
    setting.save!

    # We have created a profile in '#show' so credit_card_auth_code must be present
    @account.update_attribute(:credit_card_auth_code, 'authcode')

    assert_nothing_raised ArgumentError do
      get :hosted_success
    end
end
end
