require 'test_helper'

class Provider::Admin::AuthenticationProvidersControllerTest < ActionController::TestCase

  setup do
    @provider = Factory(:provider_account)
    @provider.settings.allow_branding
    Factory(:admin, account: @provider)
    login_provider @provider
  end

  test 'GET index' do
    get :index
    authentication_providers = assigns(:authentication_providers)
    assert_equal AuthenticationProvider.available.size, authentication_providers.length
  end

  test 'GET edit' do
    authentication_provider = Factory(:authentication_provider, account: @provider)
    get :edit, id: authentication_provider.id
    assert_equal authentication_provider, assigns(:authentication_provider)
  end

  test 'GET new' do
    @provider.settings.deny_branding!

    get :new, kind: 'github'
    assert_redirected_to provider_admin_authentication_provider_path(assigns(:authentication_provider))
  end

  test 'authentication_provider_attributes' do
    attributes = {name: "name", system_name: "system_name", client_id: "client_id", client_secret: "client_secret", token_url: "token_url", user_info_url: "user_info_url", authorize_url: "authorize_url", site: "site", kind: 'github', skip_ssl_certificate_verification: true}.stringify_keys

    post :create, authentication_provider: attributes

    authentication_provider = Factory(:authentication_provider, account: @provider)
    put :update, id: authentication_provider.id, authentication_provider: attributes
  end

  test 'POST create success' do
    post :create, authentication_provider: Factory.attributes_for(:authentication_provider)
    assert_redirected_to edit_provider_admin_authentication_provider_path(assigns(:authentication_provider))
    assert flash[:notice].present?
  end

  test 'POST create fails' do
    AuthenticationProvider.any_instance.expects(valid?: false)
    post :create, authentication_provider: {kind: 'github'}
    assert_template 'new'
  end

  test 'PUT update success' do
    authentication_provider = Factory(:authentication_provider, account: @provider)

    put :update, id: authentication_provider.id, authentication_provider: {name: "new name"}
    assert_redirected_to provider_admin_authentication_provider_path(authentication_provider)

    authentication_provider.reload

    assert_equal "new name", authentication_provider.name
    assert flash[:notice].present?, 'missing flash notice'
  end

  test 'PUT update fails' do
    authentication_provider = Factory(:authentication_provider, account: @provider)
    AuthenticationProvider.any_instance.expects(valid?: false)
    put :update, id: authentication_provider.id, authentication_provider: {name: "new name"}
    assert_template 'edit'
  end

  test 'DELETE destroy' do
    authentication_provider = Factory(:authentication_provider, account: @provider)

    delete :destroy, id: authentication_provider

    assert_redirected_to provider_admin_authentication_providers_path
    assert flash[:notice].present?, 'missing flash notice'

    assert_raise ActiveRecord::RecordNotFound do
      authentication_provider.reload
    end
  end

end
