require 'test_helper'

class Provider::PasswordsControllerTest < ActionController::TestCase

  def setup
    @provider = Factory(:provider_account)
    @user = @provider.first_admin
    @request.host = @provider.self_domain
  end

  # This test cover the posibility of tokens without 'generate_at'
  # regression test of: https://github.com/3scale/system/issues/4197
  test 'show password with lost_password_token_generated_at' do
    @user.lost_password_token = "123"
    @user.lost_password_token_generated_at = nil
    @user.save

    get :show, password_reset_token: 123
    assert_response 302
    assert flash[:error].present?
  end

end
