require File.expand_path(File.dirname(__FILE__) + '/../test_helper')

class UtilizationTest < ActionDispatch::IntegrationTest

  include TestHelpers::BackendClientStubs

  context :no_metrics_on_applications do

    setup do

      @provider = Factory :provider_account
      @plan1 = Factory :application_plan, :issuer => @provider.default_service

      @service1 = Factory :service, :account => @provider, :name => "API1"

      @plan1 = Factory :application_plan, :issuer => @service1

      @buyer = Factory :buyer_account, :provider_account => @provider

      @application1 = @plan1.create_contract_with(@buyer)

      host! @provider.admin_domain
      provider_login_with @provider.admins.first.username, 'supersecret'

      @data_empty = []

      @data_full = [
                UtilizationRecord.new(
                {:current_value=>"6000",
                :max_value=>"5000",
                :system_name=>"hits",
                :period=>"day",
                :friendly_name=>"Hits",
                :percentage=>120.0}),
                UtilizationRecord.new(
                {:current_value=>"9000",
                :max_value=>"10000",
                :system_name=>"allowed_indexes",
                :period=>"year",
                :friendly_name=>"Index",
                :percentage=>90.0}),
                UtilizationRecord.new(
                {:current_value=>"0",
                :max_value=>"666",
                :system_name=>"new_metric",
                :period=>"minute",
                :friendly_name=>"New metric with annoying long name",
                :percentage=>0.0}),
                UtilizationRecord.new(
                {:current_value=>"0",
                :max_value=>"0",
                :system_name=>"woops",
                :period=>"minute",
                :friendly_name=>"Woops",
                :percentage=>0.0})]

      @data_infinity = [
                UtilizationRecord.new(
                {:current_value=>"4010",
                :max_value=>"5000",
                :system_name=>"hits",
                :period=>"day",
                :friendly_name=>"Hits",
                :percentage=>80.2}),
                UtilizationRecord.new(
                {:current_value=>"4000",
                :max_value=>"10000",
                :system_name=>"allowed_indexes",
                :period=>"year",
                :friendly_name=>"Index",
                :percentage=>40.0}),
                UtilizationRecord.new(
                {:current_value=>"0",
                :max_value=>"666",
                :system_name=>"new_metric",
                :period=>"minute",
                :friendly_name=>"New metric with annoying long name",
                :percentage=>0.0}),
                UtilizationRecord.new(
                {:current_value=>"6",
                :max_value=>"0",
                :system_name=>"woops",
                :period=>"minute",
                :friendly_name=>"Woops",
                :percentage=>0.0})]
    end

    should 'application is unmetered' do
      stub_backend_utilization(@data_empty)
      stub_backend_get_keys

      get admin_buyers_application_path(@application1)
      assert_response :success

      doc = Nokogiri::XML.parse(body)
      assert_equal doc.search("div[@id='application-utilization']").size, 1
      assert_equal doc.search("div[@id='application-utilization']").search("table").size, 0
      assert_equal doc.search("div[@id='application-utilization']").children.first.class, Nokogiri::XML::Text
    end

    should 'application has metrics' do
      stub_backend_utilization(@data_full)
      stub_backend_get_keys

      get admin_buyers_application_path(@application1)
      assert_response :success

      doc = Nokogiri::XML.parse(body)
      assert_equal doc.search("div[@id='application-utilization']").size, 1
      table = doc.search("div[@id='application-utilization']").search("table[@class='data']")
      assert_equal table.size, 1

      assert_equal table.search("td[@class='above-100']").size, 1*2
      assert_equal table.search("td[@class='above-80']").size, 1*2
      assert_equal table.search("td[@class='above-0']").size, 2*2
      assert_equal table.search("td[@class='infinity']").size, 0*2
    end

    should 'application has metrics with one disabled over the limit' do
      stub_backend_utilization(@data_infinity)
      stub_backend_get_keys

      get admin_buyers_application_path(@application1)
      assert_response :success

      doc = Nokogiri::XML.parse(body)
      assert_equal doc.search("div[@id='application-utilization']").size, 1
      table = doc.search("div[@id='application-utilization']").search("table[@class='data']")
      assert_equal table.size, 1


      assert_equal table.search("td[@class='above-100']").size, 0*2
      assert_equal table.search("td[@class='above-80']").size, 1*2
      assert_equal table.search("td[@class='above-0']").size, 2*2
      assert_equal table.search("td[@class='infinity']").size, 1*2
    end

  end

end
