require 'test_helper'

class ThreeScale::DomainTest < ActiveSupport::TestCase

  def test_current_endpoint
    request_object = ActionDispatch::Request.new({})
    request_object.extend(ThreeScale::DevDomain::Request)
    request_object.stubs(:scheme).returns('http')
    request_object.stubs(:host).returns('alaska.com')

    assert_equal 'http://alaska.com', ThreeScale::Domain.current_endpoint(request_object)
    Rails.env.expects(:development?).returns(true).once
    assert_equal 'http://alaska.com:80', ThreeScale::Domain.current_endpoint(request_object)
    Rails.env.expects(:development?).returns(false).once
    Rails.env.expects(:preview?).returns(true).once
    assert_equal 'http://alaska.com', ThreeScale::Domain.current_endpoint(request_object)
  end

  def test_callback_endpoint
    parameters = { invitation_token: nil }
    account    = FactoryGirl.build_stubbed(:simple_provider, domain: 'supertramp.com')
    endpoint   = ThreeScale::Domain.callback_endpoint(request(parameters: parameters), account)
    assert_equal 'http://alaska.com/auth', endpoint

    parameters[:invitation_token] = '12345'
    endpoint = ThreeScale::Domain.callback_endpoint(request(parameters: parameters), account)
    assert_equal 'http://alaska.com/auth/invitations/12345', endpoint

    account.stubs(:master?).returns(true)
    endpoint = ThreeScale::Domain.callback_endpoint(request(parameters: parameters), account)
    assert_equal 'http://supertramp.com/master/devportal/auth/invitations/12345', endpoint

    parameters[:invitation_token] = nil
    endpoint = ThreeScale::Domain.callback_endpoint(request(parameters: parameters), account)
    assert_equal 'http://supertramp.com/master/devportal/auth', endpoint
  end

  private

  def request(params = {})
    mock('request', { host: 'alaska.com', scheme: 'http' }.merge(params))
  end
end
