require 'test_helper'

class ThreeScale::OAuth2::ClientTest < ActiveSupport::TestCase

  setup do
    @authentication_provider = FactoryGirl.build_stubbed(:authentication_provider)
    @client = ThreeScale::OAuth2::Client.build(@authentication_provider)
  end

  test '#callback_url' do
    base_url = 'http://foobar.com'
    expected_url = "http://foobar.com/auth/#{@authentication_provider.system_name}/callback"

    assert_equal expected_url, @client.callback_url(base_url)
  end

  test '#authorize_url' do
    base_url = 'http://foobar.com'
    authorize_url = @client.authorize_url(base_url)

    uri = URI.parse(authorize_url)
    params = CGI.parse(uri.query)

    assert_equal @authentication_provider.client_id, params["client_id"][0]
    assert_equal "http://foobar.com/auth/#{@authentication_provider.system_name}/callback", params["redirect_uri"][0]
  end

end
