/*
 * Decompiled with CFR 0.152.
 */
package de.samaflost.gwttasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FilterSet;

public class ApplicationCreator
extends Task {
    private static final String TEMPLATE = "/de/samaflost/gwttasks/build.xml";
    private File gwtHome = null;
    private File dir = null;
    private boolean eclipse = false;
    private String className = null;
    private String outDir = null;
    private File template = null;

    public void setGwtHome(File f) {
        this.gwtHome = f;
    }

    public void setDir(File f) {
        this.dir = f;
    }

    public void setEclipse(boolean b) {
        this.eclipse = b;
    }

    public void setClassName(String s) {
        this.className = s;
    }

    public void setTemplate(File f) {
        this.template = f;
    }

    public void setOutDir(String s) {
        this.outDir = s;
    }

    public void execute() {
        if (this.gwtHome == null) {
            throw new BuildException("gwtHome attribute is required");
        }
        if (this.className == null) {
            throw new BuildException("className attribute is required");
        }
        try {
            this.executeApplicationCreator();
            this.createBuildFile();
        }
        catch (IOException e) {
            throw new BuildException("applicationCreator failed", (Throwable)e);
        }
    }

    private void executeApplicationCreator() throws IOException {
        Commandline cmd = new Commandline();
        String executable = new File(this.gwtHome, "applicationCreator").getAbsolutePath();
        if (Os.isFamily((String)"windows")) {
            executable = executable + ".cmd";
        }
        cmd.setExecutable(executable);
        if (this.eclipse) {
            cmd.createArgument().setValue("-eclipse");
        }
        cmd.createArgument().setValue(this.className);
        Execute exe = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 0));
        exe.setAntRun(this.getProject());
        exe.setVMLauncher(false);
        if (this.dir != null) {
            exe.setWorkingDirectory(this.dir);
        } else {
            exe.setWorkingDirectory(this.getProject().getBaseDir());
        }
        exe.setCommandline(cmd.getCommandline());
        this.log(cmd.describeCommand(), 3);
        int retval = exe.execute();
        if (Execute.isFailure((int)retval)) {
            throw new BuildException("applicationCreator failed with return code: " + retval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuildFile() throws IOException {
        int index = this.className.lastIndexOf(".");
        String projectName = this.className;
        if (index > -1) {
            projectName = this.className.substring(index + 1);
        }
        index = this.className.indexOf(".client.");
        String classBase = this.className;
        if (index > -1) {
            classBase = this.className.substring(0, index) + this.className.substring(index + 7);
        }
        File targetDir = this.dir;
        if (this.dir == null) {
            targetDir = this.getProject().getBaseDir();
        }
        FilterSet fs = new FilterSet();
        fs.addFilter("PROJECT", projectName);
        fs.addFilter("GWT_HOME", this.gwtHome.getAbsolutePath());
        fs.addFilter("OUT", this.outDir != null ? this.outDir : "www");
        fs.addFilter("CLASS_BASE", classBase);
        InputStream in = null;
        PrintWriter out = null;
        BufferedReader bin = null;
        try {
            in = this.template == null ? ((Object)((Object)this)).getClass().getResourceAsStream(TEMPLATE) : new FileInputStream(this.template);
            bin = new BufferedReader(new InputStreamReader(in, "UTF8"));
            out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(targetDir, "build.xml")), "UTF8"));
            String line = bin.readLine();
            while (line != null) {
                out.println(fs.replaceTokens(line));
                line = bin.readLine();
            }
        }
        finally {
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException e) {
                    this.log("caught exception closing template stream: " + e.getMessage(), 0);
                }
            } else if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    this.log("caught exception closing template stream: " + e.getMessage(), 0);
                }
            }
            if (out != null) {
                out.close();
            }
        }
    }
}

