/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.util.NoSuchElementException;
import net.sf.jxls.reader.XLSRowCursor;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;

public class XLSRowCursorImpl
implements XLSRowCursor {
    int currentRowNum;
    HSSFSheet sheet;
    String sheetName;

    public XLSRowCursorImpl(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public XLSRowCursorImpl(String sheetName, HSSFSheet sheet) {
        this.sheetName = sheetName;
        this.sheet = sheet;
    }

    public int getCurrentRowNum() {
        return this.currentRowNum;
    }

    public HSSFRow getCurrentRow() {
        return this.sheet.getRow(this.currentRowNum);
    }

    public HSSFSheet getSheet() {
        return this.sheet;
    }

    public void setSheet(HSSFSheet sheet) {
        this.sheet = sheet;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public HSSFRow next() {
        if (this.hasNext()) {
            return this.sheet.getRow(this.currentRowNum++);
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        return this.currentRowNum <= this.sheet.getLastRowNum();
    }

    public void reset() {
        this.currentRowNum = 0;
    }

    public void setCurrentRowNum(int rowNum) {
        this.currentRowNum = rowNum;
    }

    public void moveForward() {
        ++this.currentRowNum;
    }

    public void moveBackward() {
        --this.currentRowNum;
    }
}

