/*
 * Decompiled with CFR 0.152.
 */
package javax.persistence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;

public class Persistence {
    protected static Set<PersistenceProvider> providers = new HashSet<PersistenceProvider>();
    protected static ProviderResolver providerResolver = new DefaultProviderResolver();

    public static ProviderResolver getProviderResolver() {
        return providerResolver;
    }

    public static void setProviderResolver(ProviderResolver resolver) {
        providerResolver = resolver;
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName) {
        return Persistence.createEntityManagerFactory(persistenceUnitName, null);
    }

    public static EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        PersistenceProvider provider;
        EntityManagerFactory emf = null;
        if (providers.size() == 0) {
            try {
                providers.addAll(providerResolver.findAllProviders());
            }
            catch (IOException exc) {
                // empty catch block
            }
        }
        Iterator<PersistenceProvider> i$ = providers.iterator();
        while (i$.hasNext() && (emf = (provider = i$.next()).createEntityManagerFactory(persistenceUnitName, properties)) == null) {
        }
        if (emf == null) {
            throw new PersistenceException("No Persistence provider for EntityManager named " + persistenceUnitName);
        }
        return emf;
    }

    public static void addProvider(PersistenceProvider provider) {
        providers.add(provider);
    }

    public static void removeProvider(String providerName) {
        Iterator<PersistenceProvider> i = providers.iterator();
        while (i.hasNext()) {
            if (!i.next().getClass().getName().equals(providerName)) continue;
            i.remove();
        }
    }

    public static void resetProviders() {
        providers = new HashSet<PersistenceProvider>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultProviderResolver
    implements ProviderResolver {
        public static final String PERSISTENCE_PROVIDER = "javax.persistence.spi.PersistenceProvider";
        public static final String SERVICE_PROVIDER_FILE = "META-INF/services/javax.persistence.spi.PersistenceProvider";
        private static final Pattern nonCommentPattern = Pattern.compile("^([^#]+)");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<PersistenceProvider> findAllProviders() throws IOException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> resources = loader.getResources(SERVICE_PROVIDER_FILE);
            HashSet<String> providerNames = new HashSet<String>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream is = url.openStream();
                try {
                    providerNames.addAll(this.providerNamesFromReader(new BufferedReader(new InputStreamReader(is))));
                }
                finally {
                    is.close();
                }
            }
            HashSet<PersistenceProvider> loadedProviders = new HashSet<PersistenceProvider>();
            for (String s : providerNames) {
                try {
                    loadedProviders.add((PersistenceProvider)loader.loadClass(s).newInstance());
                }
                catch (ClassNotFoundException exc) {
                }
                catch (InstantiationException exc) {
                }
                catch (IllegalAccessException exc) {}
            }
            return loadedProviders;
        }

        private Set<String> providerNamesFromReader(BufferedReader reader) throws IOException {
            String line;
            HashSet<String> providerNames = new HashSet<String>();
            while ((line = reader.readLine()) != null) {
                Matcher m = nonCommentPattern.matcher(line = line.trim());
                if (!m.find()) continue;
                providerNames.add(m.group().trim());
            }
            return providerNames;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ProviderResolver {
        public Collection<PersistenceProvider> findAllProviders() throws IOException;
    }
}

