/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.SuspectedException;
import org.jgroups.TimeoutException;
import org.jgroups.Transport;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.PullPushAdapter;
import org.jgroups.util.RspList;
import org.jgroups.util.Util;

public class RpcDispatcher
extends MessageDispatcher
implements ChannelListener {
    protected Object server_obj = null;
    protected Marshaller marshaller = null;
    protected List additionalChannelListeners = null;

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj) {
        super(channel, l, l2);
        channel.setChannelListener(this);
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection) {
        super(channel, l, l2, deadlock_detection);
        channel.setChannelListener(this);
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public RpcDispatcher(Channel channel, MessageListener l, MembershipListener l2, Object server_obj, boolean deadlock_detection, boolean concurrent_processing) {
        super(channel, l, l2, deadlock_detection, concurrent_processing);
        channel.setChannelListener(this);
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public RpcDispatcher(PullPushAdapter adapter, Serializable id, MessageListener l, MembershipListener l2, Object server_obj) {
        super(adapter, id, l, l2);
        Transport t;
        if (this.adapter != null && (t = this.adapter.getTransport()) != null && t instanceof Channel) {
            ((Channel)t).setChannelListener(this);
        }
        this.server_obj = server_obj;
        this.additionalChannelListeners = new ArrayList();
    }

    public String getName() {
        return "RpcDispatcher";
    }

    public void setMarshaller(Marshaller m) {
        this.marshaller = m;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public Object getServerObject() {
        return this.server_obj;
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)"this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)"this method should not be used with RpcDispatcher, but MessageDispatcher. Returning null");
        }
        return null;
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, Class[] types, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, String method_name, Object[] args, String[] signature, int mode, long timeout) {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethods(dests, method_call, mode, timeout);
    }

    public RspList callRemoteMethods(Vector dests, MethodCall method_call, int mode, long timeout) {
        byte[] buf = null;
        Message msg = null;
        RspList retval = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("dests=" + dests + ", method_call=" + method_call + ", mode=" + mode + ", timeout=" + timeout));
        }
        if (dests != null && dests.size() == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"destination list is non-null and empty: no need to send message");
            }
            return new RspList();
        }
        try {
            buf = this.marshaller != null ? this.marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            return null;
        }
        msg = new Message(null, null, buf);
        retval = super.castMessage(dests, msg, mode, timeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("responses: " + retval));
        }
        return retval;
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, Class[] types, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, types);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, String method_name, Object[] args, String[] signature, int mode, long timeout) throws TimeoutException, SuspectedException {
        MethodCall method_call = new MethodCall(method_name, args, signature);
        return this.callRemoteMethod(dest, method_call, mode, timeout);
    }

    public Object callRemoteMethod(Address dest, MethodCall method_call, int mode, long timeout) throws TimeoutException, SuspectedException {
        byte[] buf = null;
        Message msg = null;
        Object retval = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("dest=" + dest + ", method_call=" + method_call + ", mode=" + mode + ", timeout=" + timeout));
        }
        try {
            buf = this.marshaller != null ? this.marshaller.objectToByteBuffer(method_call) : Util.objectToByteBuffer(method_call);
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            return null;
        }
        msg = new Message(dest, null, buf);
        retval = super.sendMessage(msg, mode, timeout);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("retval: " + retval));
        }
        return retval;
    }

    public Object handle(Message req) {
        Object body = null;
        if (this.server_obj == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"no method handler is registered. Discarding request.");
            }
            return null;
        }
        if (req == null || req.getLength() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message or message buffer is null");
            }
            return null;
        }
        try {
            body = this.marshaller != null ? this.marshaller.objectFromByteBuffer(req.getBuffer()) : req.getObject();
        }
        catch (Throwable e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception=" + e));
            }
            return e;
        }
        if (body == null || !(body instanceof MethodCall)) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"message does not contain a MethodCall object");
            }
            return null;
        }
        MethodCall method_call = (MethodCall)body;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("[sender=" + req.getSrc() + "], method_call: " + method_call));
            }
            return method_call.invoke(this.server_obj);
        }
        catch (Throwable x) {
            this.log.error((Object)"failed invoking method", x);
            return x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            if (this.additionalChannelListeners.contains(l)) {
                return false;
            }
            this.additionalChannelListeners.add(l);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChannelListener(ChannelListener l) {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            return this.additionalChannelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelConnected(Channel channel) {
        this.start();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            Iterator i = this.additionalChannelListeners.iterator();
            while (i.hasNext()) {
                ChannelListener l = (ChannelListener)i.next();
                try {
                    l.channelConnected(channel);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelDisconnected(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            Iterator i = this.additionalChannelListeners.iterator();
            while (i.hasNext()) {
                ChannelListener l = (ChannelListener)i.next();
                try {
                    l.channelDisconnected(channel);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelClosed(Channel channel) {
        this.stop();
        List list = this.additionalChannelListeners;
        synchronized (list) {
            Iterator i = this.additionalChannelListeners.iterator();
            while (i.hasNext()) {
                ChannelListener l = (ChannelListener)i.next();
                try {
                    l.channelClosed(channel);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelShunned() {
        List list = this.additionalChannelListeners;
        synchronized (list) {
            Iterator i = this.additionalChannelListeners.iterator();
            while (i.hasNext()) {
                ChannelListener l = (ChannelListener)i.next();
                try {
                    l.channelShunned();
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelReconnected(Address new_addr) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("channel has been rejoined, old local_addr=" + this.local_addr + ", new local_addr=" + new_addr));
        }
        List list = this.additionalChannelListeners;
        synchronized (list) {
            Iterator i = this.additionalChannelListeners.iterator();
            while (i.hasNext()) {
                ChannelListener l = (ChannelListener)i.next();
                try {
                    l.channelReconnected(new_addr);
                }
                catch (Throwable t) {
                    this.log.warn((Object)"channel listener failed", t);
                }
            }
        }
    }

    public static interface Marshaller {
        public byte[] objectToByteBuffer(Object var1) throws Exception;

        public Object objectFromByteBuffer(byte[] var1) throws Exception;
    }
}

