/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;

public class ProtocolStack
extends Protocol
implements Transport {
    private Protocol top_prot = null;
    private Protocol bottom_prot = null;
    private final Configurator conf = new Configurator();
    private final String setup_string;
    private JChannel channel = null;
    private boolean stopped = true;
    public final TimeScheduler timer = new TimeScheduler(5000L);
    Promise start_promise = null;
    Promise stop_promise = null;
    public static final int ABOVE = 1;
    public static final int BELOW = 2;

    public ProtocolStack(JChannel channel, String setup_string) throws ChannelException {
        this.setup_string = setup_string;
        this.channel = channel;
        ClassConfigurator.getInstance(true);
    }

    public Vector getProtocols() {
        Vector<Protocol> v = new Vector<Protocol>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            v.addElement(p);
        }
        return v;
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuffer sb = new StringBuffer();
        Protocol prot = this.top_prot;
        while (prot != null) {
            Properties tmpProps;
            String name = prot.getName();
            if (name == null) continue;
            if ("ProtocolStack".equals(name)) break;
            sb.append(name);
            if (include_properties && (tmpProps = prot.getProperties()) != null) {
                sb.append('\n');
                Iterator<Map.Entry<Object, Object>> it = tmpProps.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, Object> entry = it.next();
                    sb.append(entry + "\n");
                }
            }
            sb.append('\n');
            prot = prot.getDownProtocol();
        }
        return sb.toString();
    }

    public void setup() throws Exception {
        if (this.top_prot == null) {
            this.top_prot = this.conf.setupProtocolStack(this.setup_string, this);
            if (this.top_prot == null) {
                throw new Exception("ProtocolStack.setup(): couldn't create protocol stack");
            }
            this.top_prot.setUpProtocol(this);
            this.bottom_prot = this.conf.getBottommostProtocol(this.top_prot);
            this.conf.startProtocolStack(this.bottom_prot);
        }
    }

    public Protocol createProtocol(String prot_spec) throws Exception {
        return this.conf.createProtocol(prot_spec, this);
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot) throws Exception {
        this.conf.insertProtocol(prot, position, neighbor_prot, this);
    }

    public void removeProtocol(String prot_name) throws Exception {
        this.conf.removeProtocol(prot_name);
    }

    public Protocol findProtocol(String name) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            String prot_name = tmp.getName();
            if (prot_name == null || !prot_name.equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public void destroy() {
        if (this.top_prot != null) {
            this.conf.stopProtocolStack(this.top_prot);
            this.top_prot = null;
        }
    }

    public void startStack() throws Exception {
        Object start_result = null;
        if (!this.stopped) {
            return;
        }
        this.timer.start();
        if (this.start_promise == null) {
            this.start_promise = new Promise();
        } else {
            this.start_promise.reset();
        }
        this.down(new Event(61));
        start_result = this.start_promise.getResult(0L);
        if (start_result != null && start_result instanceof Throwable) {
            if (start_result instanceof Exception) {
                throw (Exception)start_result;
            }
            throw new Exception("ProtocolStack.start(): exception is " + start_result);
        }
        this.stopped = false;
    }

    public void startUpHandler() {
    }

    public void startDownHandler() {
    }

    public void stopStack() {
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.stopped) {
            return;
        }
        if (this.stop_promise == null) {
            this.stop_promise = new Promise();
        } else {
            this.stop_promise.reset();
        }
        this.down(new Event(63));
        this.stop_promise.getResult(5000L);
        this.stopped = true;
    }

    public void flushEvents() {
    }

    public void stopInternal() {
    }

    public void send(Message msg) throws Exception {
        this.down(new Event(1, msg));
    }

    public Object receive(long timeout) throws Exception {
        throw new Exception("ProtocolStack.receive(): not implemented !");
    }

    public String getName() {
        return "ProtocolStack";
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 62: {
                if (this.start_promise != null) {
                    this.start_promise.setResult(evt.getArg());
                }
                return;
            }
            case 64: {
                if (this.stop_promise != null) {
                    this.stop_promise.setResult(evt.getArg());
                }
                return;
            }
        }
        if (this.channel != null) {
            this.channel.up(evt);
        }
    }

    public void down(Event evt) {
        if (this.top_prot != null) {
            this.top_prot.receiveDownEvent(evt);
        } else {
            this.log.error((Object)"no down protocol available !");
        }
    }

    protected void receiveUpEvent(Event evt) {
        this.up(evt);
    }

    public void startWork() {
    }

    public void stopWork() {
    }
}

