/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.WSException;
import org.jboss.ws.core.HTTPMessageAbstraction;
import org.jboss.ws.core.soap.XMLFragment;
import org.jboss.wsf.common.IOUtils;

public class HTTPMessageImpl
implements HTTPMessageAbstraction {
    private MimeHeaders mimeHeaders;
    private XMLFragment xmlFragment;

    public HTTPMessageImpl(MimeHeaders mimeHeaders, InputStream inputStream) {
        this.mimeHeaders = mimeHeaders;
        this.xmlFragment = new XMLFragment(new StreamSource(HTTPMessageImpl.cache(inputStream)));
    }

    private static InputStream cache(InputStream is) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            IOUtils.copyStream((OutputStream)baos, (InputStream)is);
            byte[] bytes = baos.toByteArray();
            return new ByteArrayInputStream(bytes);
        }
        catch (IOException e) {
            throw new WSException(e);
        }
    }

    public HTTPMessageImpl(Source source) {
        this.mimeHeaders = new MimeHeaders();
        this.xmlFragment = new XMLFragment(source);
        this.initDefaultMimeHeaders();
    }

    public HTTPMessageImpl(Result result) {
        this.mimeHeaders = new MimeHeaders();
        this.xmlFragment = new XMLFragment(result);
        this.initDefaultMimeHeaders();
    }

    public boolean doValidate() {
        this.xmlFragment.toElement();
        return true;
    }

    private void initDefaultMimeHeaders() {
        this.mimeHeaders.setHeader("Content-Type", "text/xml; charset=UTF-8");
    }

    public XMLFragment getXmlFragment() {
        return this.xmlFragment;
    }

    public void setXmlFragment(XMLFragment xmlFragment) {
        this.xmlFragment = xmlFragment;
    }

    public MimeHeaders getMimeHeaders() {
        if (this.mimeHeaders == null) {
            this.mimeHeaders = new MimeHeaders();
        }
        return this.mimeHeaders;
    }

    public void setMimeHeaders(MimeHeaders mimeHeaders) {
        this.mimeHeaders = mimeHeaders;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.xmlFragment.writeTo(outputStream);
    }

    public boolean isFaultMessage() {
        return false;
    }

    public void addAttachmentPart(AttachmentPart part) {
        throw new NotImplementedException();
    }
}

