/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl.xsd;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.Constants;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSComplexTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSElementDeclaration;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSErrorHandler;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSSimpleTypeDefinition;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSStringList;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSTypeDefinition;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.management.ServerConfigFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaUtils {
    private static SchemaUtils ourInstance = new SchemaUtils();
    protected static String xsNS = "http://www.w3.org/2001/XMLSchema";
    private static Map<Class, QName> toolsTypeMappingOverride = new HashMap<Class, QName>();

    public static SchemaUtils getInstance() {
        return ourInstance;
    }

    private SchemaUtils() {
    }

    public boolean isArrayType(XSParticle xsparticle) {
        int maxOccurs = xsparticle.getMaxOccurs();
        return xsparticle.getMaxOccursUnbounded() || maxOccurs > 1;
    }

    public static boolean isWrapperArrayType(XSTypeDefinition xst) {
        return SchemaUtils.unwrapArrayType(xst) != null;
    }

    public static XSElementDeclaration unwrapArrayType(XSTypeDefinition xst) {
        if (!(xst instanceof XSComplexTypeDefinition)) {
            return null;
        }
        XSComplexTypeDefinition xc = (XSComplexTypeDefinition)xst;
        if (xc.getContentType() == 0) {
            return null;
        }
        XSParticle xsp = xc.getParticle();
        if (xsp == null) {
            return null;
        }
        XSTerm xsterm = xsp.getTerm();
        if (!(xsterm instanceof XSModelGroup)) {
            return null;
        }
        XSModelGroup xm = (XSModelGroup)xsterm;
        XSObjectList xo = xm.getParticles();
        if (xo.getLength() != 1) {
            return null;
        }
        XSParticle xp = (XSParticle)xo.item(0);
        XSTerm term = xp.getTerm();
        if (!(xp.getMaxOccursUnbounded() || xp.getMaxOccurs() > 1) || !(term instanceof XSElementDeclaration)) {
            return null;
        }
        return (XSElementDeclaration)term;
    }

    public static QName handleSimpleType(XSSimpleTypeDefinition simple) {
        if (simple == null) {
            throw new IllegalArgumentException("XSSimpleTypeDefinition passed is null");
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(simple.getNamespace())) {
            return SchemaUtils.createQNameFromXSSimpleType(simple);
        }
        switch (simple.getVariety()) {
            case 2: {
                return SchemaUtils.handleSimpleType(simple.getItemType());
            }
            case 3: {
                XSObjectList list = simple.getMemberTypes();
                if (list.getLength() > 0) {
                    return SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)list.item(0));
                }
                throw new WSException("Empty union type not expected");
            }
            case 0: {
                throw new WSException("Absent variety is not supported in simple types");
            }
        }
        XSTypeDefinition base = simple.getBaseType();
        while (!"http://www.w3.org/2001/XMLSchema".equals(base.getNamespace())) {
            base = base.getBaseType();
        }
        if (!(base instanceof XSSimpleTypeDefinition)) {
            throw new WSException("Expected base type to be a simple type");
        }
        return new QName(base.getNamespace(), base.getName());
    }

    public QName patchXSDQName(QName qname) {
        if (qname == null) {
            return null;
        }
        return new QName("http://www.w3.org/2001/XMLSchema", qname.getLocalPart(), "xsd");
    }

    public XSElementDeclaration createXSElementDeclaration(QName xmlName, XSTypeDefinition xst) {
        String name = xmlName.getLocalPart();
        String ns = xmlName.getNamespaceURI();
        JBossXSElementDeclaration jbel = new JBossXSElementDeclaration(name, ns);
        jbel.setTypeDefinition(xst);
        jbel.setScope((short)1);
        return jbel;
    }

    public static QName createQNameFromXSSimpleType(XSSimpleTypeDefinition xs) {
        String nsuri = xs.getNamespace();
        String localpart = xs.getName();
        if (xsNS.equals(nsuri)) {
            return new QName(nsuri, localpart, "xsd");
        }
        return new QName(nsuri, localpart);
    }

    public QName getToolsOverrideInTypeMapping(Class javaType) {
        return toolsTypeMappingOverride.get(javaType);
    }

    public boolean hasGlobalElement(QName xmlName, XSModel xsmodel) {
        if (xmlName == null) {
            throw new IllegalArgumentException("xmlName is null");
        }
        if (xsmodel == null) {
            throw new IllegalArgumentException("XSModel is null");
        }
        boolean bool = false;
        String name = xmlName.getLocalPart();
        if (name == null) {
            throw new IllegalArgumentException("xmlName has a null name");
        }
        String ns = xmlName.getNamespaceURI();
        if (ns == null) {
            throw new IllegalArgumentException("xmlName has a null namespace");
        }
        if (xsmodel.getElementDeclaration(name, ns) != null) {
            bool = true;
        }
        return bool;
    }

    public boolean hasComplexTypeDefinition(QName xmlType, URL xsdLocation) {
        if (xsdLocation == null) {
            throw new IllegalArgumentException("xsdLocation is null");
        }
        XSModel xsmodel = this.parseSchema(xsdLocation);
        return this.hasComplexTypeDefinition(xmlType, xsmodel);
    }

    public boolean hasGlobalElement(QName xmlName, URL xsdLocation) {
        if (xmlName == null) {
            throw new IllegalArgumentException("xmlName is null");
        }
        if (xsdLocation == null) {
            throw new IllegalArgumentException("xsdLocation is null");
        }
        XSModel xsmodel = this.parseSchema(xsdLocation);
        boolean bool = false;
        String name = xmlName.getLocalPart();
        if (name == null) {
            throw new IllegalArgumentException("xmlName has a null name");
        }
        String ns = xmlName.getNamespaceURI();
        if (ns == null) {
            throw new IllegalArgumentException("xmlName has a null namespace");
        }
        if (xsmodel.getElementDeclaration(name, ns) != null) {
            bool = true;
        }
        return bool;
    }

    public boolean hasComplexTypeDefinition(QName xmlType, XSModel xsmodel) {
        if (xmlType == null) {
            throw new IllegalArgumentException("xmlType is null");
        }
        if (xsmodel == null) {
            throw new IllegalArgumentException("XSModel is null");
        }
        boolean bool = false;
        String name = xmlType.getLocalPart();
        if (name == null) {
            throw new IllegalArgumentException("xmlName has a null name");
        }
        String ns = xmlType.getNamespaceURI();
        if (ns == null) {
            throw new IllegalArgumentException("xmlName has a null namespace");
        }
        if (xsmodel.getTypeDefinition(name, ns) != null) {
            bool = true;
        }
        return bool;
    }

    public String getFormattedString(XSTypeDefinition xstype) {
        String ns = xstype.getNamespace();
        String name = xstype.getName();
        if (!ns.equals(xsNS)) {
            name = this.getPrefix(ns) + ":" + name;
        }
        return name;
    }

    public QName getQName(XSTypeDefinition xstype) {
        String prefix = null;
        String ns = xstype.getNamespace();
        String name = xstype.getName();
        prefix = !ns.equals(xsNS) ? "tns" : "xsd";
        return new QName(ns, name, prefix);
    }

    public JBossXSTypeDefinition getSchemaBasicType(String localpart) {
        JBossXSTypeDefinition xt = null;
        if ("anyType".equals(localpart)) {
            JBossXSComplexTypeDefinition ct = new JBossXSComplexTypeDefinition(localpart, "http://www.w3.org/2001/XMLSchema");
            ct.setContentType((short)0);
            xt = ct;
        } else {
            XSSimpleType xstype = new SchemaDVFactoryImpl().getBuiltInType(localpart);
            xt = new JBossXSSimpleTypeDefinition((XSSimpleTypeDefinition)xstype);
        }
        return xt;
    }

    public XSLoader getXSLoader() {
        XMLSchemaLoader xsloader = new XMLSchemaLoader();
        JBossXSErrorHandler eh = new JBossXSErrorHandler();
        xsloader.setErrorHandler((XMLErrorHandler)eh);
        xsloader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", (Object)new XMLGrammarPoolImpl());
        return xsloader;
    }

    public XSLoader getXSLoader(XMLErrorHandler xeh, XMLEntityResolver xer) {
        XMLSchemaLoader xsloader = new XMLSchemaLoader();
        xsloader.setEntityResolver(xer);
        xsloader.setErrorHandler(xeh);
        xsloader.setProperty("http://apache.org/xml/properties/internal/grammar-pool", (Object)new XMLGrammarPoolImpl());
        return xsloader;
    }

    public XSModel parseSchema(URL schemaLoc) {
        return this.parseSchema(schemaLoc.toExternalForm());
    }

    public XSModel parseSchema(String schemaLoc) {
        XSLoader xsloader = this.getXSLoader();
        XSModel xsModel = xsloader.loadURI(schemaLoc);
        if (xsModel == null) {
            throw new WSException("Cannot parse schema: " + schemaLoc);
        }
        return xsModel;
    }

    public XSModel parseSchema(List<String> locations) {
        JBossXSStringList slist = new JBossXSStringList(locations);
        XSLoader xsloader = this.getXSLoader();
        return xsloader.loadURIList((StringList)slist);
    }

    public boolean isEmptySchema(XSModel xsmodel) {
        if (xsmodel == null) {
            return true;
        }
        String targetNS = SchemaUtils.getTargetNamespace(xsmodel);
        if (targetNS == null) {
            throw new WSException("Target Namespace of xsmodel is null");
        }
        XSNamedMap tmap = xsmodel.getComponentsByNamespace((short)3, targetNS);
        XSNamedMap emap = xsmodel.getComponentsByNamespace((short)2, targetNS);
        if (tmap != null && tmap.getLength() > 0) {
            return false;
        }
        return emap == null || emap.getLength() <= 0;
    }

    public boolean isEmptySchema(XSModel xsmodel, String namespace) {
        if (xsmodel == null) {
            return true;
        }
        if (namespace == null) {
            throw new WSException("Target Namespace of xsmodel is null");
        }
        XSNamedMap tmap = xsmodel.getComponentsByNamespace((short)3, namespace);
        XSNamedMap emap = xsmodel.getComponentsByNamespace((short)2, namespace);
        if (tmap != null && tmap.getLength() > 0) {
            return false;
        }
        return emap == null || emap.getLength() <= 0;
    }

    public static String getSchemaDefinitions(String targetNS) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(" targetNamespace='" + targetNS + "'");
        buffer.append(" xmlns='http://www.w3.org/2001/XMLSchema'");
        buffer.append(" xmlns:soap11-enc='http://schemas.xmlsoap.org/soap/encoding/'");
        buffer.append(" xmlns:tns='" + targetNS + "'");
        buffer.append(" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'");
        buffer.append(">");
        return buffer.toString();
    }

    public static File getSchemaTempFile(String targetNS) throws IOException {
        if (targetNS.length() == 0) {
            throw new IllegalArgumentException("Invalid null target namespace");
        }
        String fname = targetNS;
        if (fname.indexOf("://") > 0) {
            fname = fname.substring(fname.indexOf("://") + 3);
        }
        File tmpdir = null;
        try {
            SPIProvider spiProvider = SPIProviderResolver.getInstance().getProvider();
            ServerConfig serverConfig = ((ServerConfigFactory)spiProvider.getSPI(ServerConfigFactory.class)).getServerConfig();
            File tmpDir = serverConfig.getServerTempDir();
            tmpdir = serverConfig.getServerTempDir();
            tmpdir = new File(tmpdir.getCanonicalPath() + "/jbossws");
            tmpdir.mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        fname = fname.replace('/', '_');
        fname = fname.replace(':', '_');
        fname = fname.replace('?', '_');
        fname = fname.replace('#', '_');
        return File.createTempFile("JBossWS_" + fname, ".xsd", tmpdir);
    }

    public static String getTargetNamespace(XSModel xsmodel) {
        if (xsmodel == null) {
            throw new IllegalArgumentException("Illegal Null Argument: xsmodel");
        }
        String targetNS = null;
        StringList slist = xsmodel.getNamespaces();
        int len = slist != null ? slist.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            String ns = slist.item(i);
            if ("http://www.w3.org/2001/XMLSchema".equals(ns)) continue;
            targetNS = ns;
            break;
        }
        return targetNS;
    }

    private String getPrefix(String namespace) {
        if ("http://schemas.xmlsoap.org/soap/encoding/".equals(namespace)) {
            return "soap11-enc";
        }
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(namespace) || "http://www.w3.org/2003/05/soap-envelope".equals(namespace)) {
            return "env";
        }
        return "tns";
    }

    static {
        toolsTypeMappingOverride.put(byte[].class, Constants.TYPE_LITERAL_BASE64BINARY);
    }
}

