package com.redhat.installer.postinstall;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * Incredibly non-general class to modify dtgov-sramp-repo-seed-cli-commands.txt
 * @author thauser
 *
 */

public class DTGovCliModifier {

	private static final String FILE = "file";
	
	public static void run(AbstractUIProcessHandler handler, String[]args) throws Exception{
		AutomatedInstallData idata = AutomatedInstallData.getInstance();
		ArgumentParser parser = new ArgumentParser();
		parser.parse(args);
		// we use a file arg just because the file name may change
		File dtgovCliFile = new File(parser.getProperty(FILE));
		

		String line;
		BufferedReader br = new BufferedReader(new FileReader(dtgovCliFile));
		StringBuilder sb = new StringBuilder();
		// non-portable, but fast
		while ((line = br.readLine())!= null){
			if (line.endsWith("s-ramp-server")){
				line = line + " dtgovworkflows " + idata.getVariable("workflows.plaintext.password");
			} 
/*			line = line.replace("admin","dtgovworkflows");
			line = line.replace("overlord", idata.getVariable("workflows.plaintext.password"));*/
			sb.append(line);
			sb.append(System.getProperty("line.separator"));
		}
		br.close();
		
		
		String tempFileName = parser.getProperty(FILE)+"TEMP";
		File tempDtgovCliFile = new File(tempFileName);
		idata.setVariable("dtgov.temp.cli.file", tempFileName);
		
		if (tempDtgovCliFile.exists())
			tempDtgovCliFile.delete();
		
		FileWriter writer = new FileWriter(tempDtgovCliFile, false);
		writer.write(sb.toString());
		handler.logOutput("Successfully wrote " + tempDtgovCliFile.getPath(), false);
		writer.close();

		//handler.logOutput("Failed to write properties information to " + dtgovCliFile.getPath(), true);
		
	}
	
}
