package com.redhat.installer.layering.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.asconfiguration.keystore.validator.KeystoreValidator;

import java.io.File;

public class PreExistingVaultValidator extends KeystoreValidator
{
    @Override
    protected Status performAdditionalChecksOnSuccess(String algorithm) {
        return Status.OK;
    }

    @Override
    protected boolean hasAdditionalChecksOnSuccess() {
        return false;
    }

    @Override
    public String getKeystorePath() {
        return AutomatedInstallData.getInstance().getVariable("vault.keystoreloc");
    }

    @Override
    public String getEncryptedDirPath() {
        return null;
    }

    @Override
    public String[] getSupportedFormats() {
        return AutomatedInstallData.getInstance().getVariable("preexisting.vault.allowed.keystore.types").split(",");
    }

    @Override
    public char[] getKeystorePassword() {
        return AutomatedInstallData.getInstance().getVariable("vault.keystorepwd").toCharArray();
    }

    @Override
    public boolean hasAdditionalChecksOnFail() {
        return true;
    }

    /**
     * This method attempts to check default locations if the user used a default keystore,
     * since querying the server for jboss.home.dir (the default location) isn't possible at the
     * time we need to check
     *
     * @param result
     * @return
     */
    @Override
    public Status performAdditionalChecksOnFail(int result) {

        String keystoreLoc = AutomatedInstallData.getInstance().getInstallPath() + File.separator + "vault.keystore";
        char[] pwd = getKeystorePassword();
        int newResult = isValidKeystore(keystoreLoc, pwd, getSupportedFormats());

        /**
         * We just check the isValidKeystore again, attempting to use the default installer location of the vault.
         * If this fails, we assume the first check was correct, and use its message and its error Id, and simply return a warning.
         */
        if (newResult == 0) {
            setVariable();
            return Status.OK;

        } else {
            return Status.WARNING;
        }
    }
    @Override
    public void setVariable() {
        AutomatedInstallData.getInstance().setVariable("installVault", "true");
    }

    @Override
    public Status getFailureStatus() {
        return Status.ERROR;
    }

    @Override
    protected boolean getCondition() {
        return true;
    }
}
