package com.izforge.izpack.gui;

import javax.swing.*;
import javax.swing.border.Border;
import java.awt.*;

/**
 * Created by aabulawi on 18/03/15.
 */
public class UserInputGuiUtils {


    private static int baseIndent = 20;

    public static JPanel createMainPanel(boolean isOpaque){
        JPanel panel = new JPanel();
        panel.setOpaque(isOpaque);
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        return panel;
    }

    public static JPanel createContentPanel(boolean isOpaque){
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setOpaque(isOpaque);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.LAST_LINE_START;
        gbc.weightx = 10;
        gbc.weighty = 10;
        gbc.gridx = 100;
        gbc.gridy = 100;
        gbc.gridwidth = 100;
        gbc.gridheight = 100;
        gbc.fill = GridBagConstraints.BOTH;
        contentPanel.add(Box.createGlue(), gbc);
        contentPanel.setBorder(BorderFactory.createEmptyBorder());
        return contentPanel;
    }

    public static GridBagConstraints getContentPanelConstraints(){
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.SOUTH;
        gbc.weightx = 10;
        gbc.weighty = 10;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = GridBagConstraints.BOTH;
        return gbc;
    }

    public static JScrollPane createPanelScroller(Border border, JPanel panel, boolean isOpaque)
    {
        JScrollPane scroller = new JScrollPane(panel, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        scroller.setViewportBorder(border);
        scroller.getVerticalScrollBar().setBorder(border);
        scroller.getHorizontalScrollBar().setBorder(border);
        scroller.getViewport().setOpaque(isOpaque);
        scroller.setOpaque(isOpaque);
        scroller.setBorder(border);
        scroller.getVerticalScrollBar().setUnitIncrement(15);
        return scroller;
    }

    public static GridBagConstraints getTitleConstraints(int gridBagAnchor){
        GridBagConstraints titleConstraints = new GridBagConstraints();
        titleConstraints.insets= new Insets(10,20,10,20);
        titleConstraints.gridheight = 1;
        titleConstraints.gridwidth = 1;
        titleConstraints.weightx = 0;
        titleConstraints.weighty = 0;
        titleConstraints.fill = GridBagConstraints.NONE;
        titleConstraints.anchor = gridBagAnchor;
        titleConstraints.gridx = 0;
        titleConstraints.gridy = 0;
        return titleConstraints;
    }

    public static GridBagConstraints createNonFullLineElementConstraint(int row, int col, int alignment, int indent) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = alignment;
        gbc.gridheight = 1;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.weightx = 0;
        gbc.weighty = 0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 20);
        return gbc;
    }

    public static GridBagConstraints createFullLineElementConstraint(int row, int col, int indent) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.WEST;
        gbc.gridheight = 1;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.weightx = 0;
        gbc.weighty = 0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 40);
        return gbc;
    }


    public static GridBagConstraints createCheckAndRadioConstraint(int row, int col, int indent, double weightx){
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridheight = 1;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.weightx = weightx;
        gbc.weighty = 0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(0, baseIndent + indent, 0, 20);
        return gbc;
    }

    public static GridBagConstraints createAlignedElementConstraint(int row, int col, int indent, int fill){
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = fill;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 0;
        gbc.weighty = 0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent+indent, 2, 20);
        return gbc;
    }

    public static GridBagConstraints createFixedSizeAlignedElementConstraint(int row, int col, int indent, double weightx){
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.weightx = weightx;
        gbc.weighty = 0;
        gbc.gridx = col;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent+indent, 2, 20);
        return gbc;
    }

    public static GridBagConstraints createDividerConstraints(int row, int indent){
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.HORIZONTAL;
        gbc.anchor = GridBagConstraints.NORTHWEST;
        gbc.gridheight = 1;
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.weightx = 10000;
        gbc.weighty = 0;
        gbc.gridx = 0;
        gbc.gridy = row;
        gbc.insets = new Insets(2, baseIndent + indent, 2, 20);
        return gbc;
    }

}
