package com.redhat.installer.asconfiguration.processpanel.postinstallation;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.installation.processpanel.ProcessPanelHelper;

public class Infinispan extends PostInstallation {

    @Override
    protected Class getClassName() {
        return Infinispan.class;
    }

    @Override
    protected boolean performOperation() {
        return installInfinispan();
    }

    private static boolean installInfinispan() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String infinispanContainer = idata.getVariable("infinispan.container");
        String infinispanJndi = idata.getVariable("infinispan.jndiname");
        String infinispanLocalCache = idata.getVariable("infinispan.localcache");
        String infinispanTransMode = idata.getVariable("infinispan.transactionmode");
        String infinispanEvictStrat = idata.getVariable("infinispan.evictionstrat");
        String infinispanEvictMaxEntries = idata.getVariable("infinispan.evictionmax");
        String infinispanExpirationMax = idata.getVariable("infinispan.expirationmax");
        boolean result = serverCommands.addInfinispanCache(infinispanContainer,
                infinispanJndi, infinispanLocalCache, infinispanTransMode,
                infinispanEvictStrat, infinispanEvictMaxEntries,
                infinispanExpirationMax);
        if (!result){
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.infinispan.install.failure"), true);
        } else {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("postinstall.processpanel.infinispan.install.success"), false);
        }
        return result;
    }
}
