package org.jboss.brmsbpmsuite.elytronmigration;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class ElytronMigrationApp {

    public static void main(String[] args) {
        if (args.length != 1) {
            printUsageAndExit();
        }
        Path realmPath = Paths.get(args[0]);
        if (!Files.exists(realmPath)) {
            System.out.println("ERROR: The path specified for the Kie filesystem realm does not exist");
            printUsageAndExit();
        }
        if (!Files.isDirectory(realmPath)) {
            System.out.println("ERROR: The path specified for the Kie filesystem realm is not a directory");
            printUsageAndExit();
        }
        new FilesystemRealmTransformer(realmPath).transform();
    }

    private static void printUsageAndExit() {
        System.out.println("USAGE: migrate-fs-realm.[sh|bat] <path-to-kie-fs-realm-users>");
        System.exit(1);
    }
}
