/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.NTFJMSEvent;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.NTFManager;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4CTTIkpdnrmp;
import oracle.jdbc.driver.T4CTTIkpdnrnf;
import oracle.jdbc.driver.T4CTTIkpdnrpay;
import oracle.jdbc.driver.T4CTTIkpdnrreq;

final class T4CTTIoaqnfy
extends T4CTTIfun {
    byte[] jmsConnectionId = null;
    boolean isMarshalOver = false;
    boolean needToBeClosed = false;
    OracleConnection conn = null;
    T4CTTIkpdnrnf notificationHeader = null;
    T4CTTIkpdnrmp messageProperties = null;
    T4CTTIkpdnrpay payload = null;
    NTFManager ntfManager = null;
    T4CMAREngine mar;
    String databaseUniqueIdentifier;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIoaqnfy(T4CConnection t4CConnection, String string) throws SQLException {
        super(t4CConnection, (byte)3);
        assert (t4CConnection != null && string != null) : "connection is " + t4CConnection + ", jmsConnectionId is " + string;
        this.setFunCode((short)187);
        this.conn = t4CConnection;
        this.mar = t4CConnection.mare;
        this.jmsConnectionId = this.mar.conv.StringToCharBytes(string);
    }

    @Override
    void marshal() throws IOException {
        T4CTTIkpdnrreq t4CTTIkpdnrreq = new T4CTTIkpdnrreq((T4CConnection)this.conn);
        t4CTTIkpdnrreq.send(this.jmsConnectionId, T4CTTIkpdnrreq.OpCode.INIT_KPDNRREQ);
        this.isMarshalOver = true;
    }

    @Override
    void readOAC() throws SQLException, IOException {
        this.notificationHeader = new T4CTTIkpdnrnf((T4CConnection)this.conn);
        this.messageProperties = new T4CTTIkpdnrmp((T4CConnection)this.conn);
        this.payload = new T4CTTIkpdnrpay((T4CConnection)this.conn);
        while (true) {
            this.notificationHeader.receive();
            if (this.notificationHeader.messageType == 4) continue;
            this.messageProperties.receive();
            this.payload.receive();
            this.createAndGenerateEvent();
        }
    }

    public void createAndGenerateEvent() throws SQLException {
        int n2 = PhysicalConnection.ntfManager.getJDBCRegId(this.notificationHeader.getRegistrationId());
        NTFJMSRegistration nTFJMSRegistration = (NTFJMSRegistration)PhysicalConnection.ntfManager.getRegistration(n2);
        NTFJMSEvent nTFJMSEvent = new NTFJMSEvent(this);
        nTFJMSEvent.setAqMessageProperites(this.messageProperties.getAqMessageProperties());
        nTFJMSEvent.setJmsMessageProperties(this.messageProperties.getJmsMessageProperties());
        nTFJMSEvent.setMessageId(this.messageProperties.getMessageId());
        nTFJMSEvent.setPayload(this.payload.getRawPayload());
        nTFJMSEvent.setConsumerName(this.notificationHeader.getConsumerName());
        nTFJMSEvent.setQueueName(this.notificationHeader.getNotificationQueue());
        nTFJMSEvent.setRegistration(this.notificationHeader.getNotificationQueue());
        nTFJMSRegistration.notify(nTFJMSEvent);
    }

    public void stopListening() {
        while (!this.isMarshalOver) {
        }
        this.needToBeClosed = true;
    }
}

