/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.screens.datamodeller.backend.server;

import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorEditorContent;
import org.kie.workbench.common.screens.datamodeller.service.PersistenceDescriptorService;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;

import static org.junit.Assert.assertEquals;
import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

@RunWith(MockitoJUnitRunner.class)
public class PersistenceDescriptorEditorServiceImplTest {

    @Mock
    private IOService ioService;

    @Mock
    private RenameService renameService;

    @Mock
    private PersistenceDescriptorService descriptorService;

    @Mock
    private SaveAndRenameServiceImpl<PersistenceDescriptorEditorContent, Metadata> saveAndRenameService;

    private PersistenceDescriptorEditorServiceImpl service;

    @Before
    public void setup() {
        service = new PersistenceDescriptorEditorServiceImpl(ioService,
                                                             descriptorService,
                                                             renameService,
                                                             saveAndRenameService);
    }

    @Test
    public void testSaveAndRename() throws Exception {

        final Path path = mock(Path.class);
        final Path expectedPath = mock(Path.class);
        final Metadata metadata = mock(Metadata.class);
        final PersistenceDescriptorEditorContent content = mock(PersistenceDescriptorEditorContent.class);
        final String newName = "newName";
        final String comment = "comment";

        doReturn(expectedPath).when(saveAndRenameService).saveAndRename(path, newName, metadata, content, comment);

        final Path actualPath = service.saveAndRename(path, newName, metadata, content, comment);

        verify(saveAndRenameService).saveAndRename(path, newName, metadata, content, comment);

        assertEquals(expectedPath, actualPath);
    }

    @Test
    public void testRename() throws Exception {

        final Path path = mock(Path.class);
        final Path expectedPath = mock(Path.class);
        final String newName = "newName";
        final String comment = "comment";

        doReturn(expectedPath).when(renameService).rename(path, newName, comment);

        final Path actualPath = service.rename(path, newName, comment);

        verify(renameService).rename(path, newName, comment);

        assertEquals(expectedPath, actualPath);
    }
}
