/*
Copyright (C) 2018 Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package config

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"github.com/spf13/viper"
)

func TestNoExplicitRouteSuffixDefaultsToNip(t *testing.T) {
	var testConfig = struct {
		Ip            string
		RoutingSuffix string
	}{
		"192.168.99.42",
		"192.168.99.42.nip.io",
	}

	expectedRoutingSuffix := testConfig.Ip + ".nip.io"
	actualRoutingSuffix := GetDefaultRoutingSuffix(testConfig.Ip)

	assert.Equal(t, expectedRoutingSuffix, actualRoutingSuffix)
}

func TestExplicitRouteSuffixGetApplied(t *testing.T) {
	var testConfig = struct {
		Ip            string
		RoutingSuffix string
	}{
		"192.168.99.42",
		"192.168.99.42.nip.io",
	}

	explicitRoutingSuffix := "acme.com"
	expectedRoutingSuffix := "acme.com"

	viper.Set(RoutingSuffix.Name, explicitRoutingSuffix)
	defer viper.Reset()

	actualRoutingSuffix := GetDefaultRoutingSuffix(testConfig.Ip)

	assert.Equal(t, expectedRoutingSuffix, actualRoutingSuffix)
}
