/* IP4xxx co-processor ELF support for BFD.
   Copyright (C) 2000 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef _ELF_IP4KMATH_H
#define _ELF_IP4KMATH_H

#include "elf/reloc-macros.h"

/* Relocations.  */
START_RELOC_NUMBERS (elf_ip4kmath_reloc_type)
  RELOC_NUMBER (R_IP4KMATH_NONE, 0)
  RELOC_NUMBER (R_IP4KMATH_16, 1)
  RELOC_NUMBER (R_IP4KMATH_32, 2)
  RELOC_NUMBER (R_IP4KMATH_OFFSET_16, 3)
  RELOC_NUMBER (R_IP4KMATH_DATA, 4)
  RELOC_NUMBER (R_IP4KMATH_INSN, 5)
END_RELOC_NUMBERS(R_IP4KMATH_max)

/* Define the data & instruction memory discriminator.  In a linked
   executable, an symbol should be deemed to point to an instruction
   if ((address & IP4KMATH_INSN_MASK) == IP4KMATH_INSN_VALUE), and similarly
   for the data space.  See also `ld/emulparams/elf32ip4kmath.sh'.  */
/* ??? Consider extending the _MASK values to include all the
   intermediate bits that must be zero due to the limited physical
   memory size on the IP4KMATH.  */

#define IP4KMATH_DATA_MASK   0xff000000
#define IP4KMATH_DATA_VALUE  0x03000000
#define IP4KMATH_INSN_MASK   0xff000000
#define IP4KMATH_INSN_VALUE  0x04000000


#endif /* _ELF_IP4KMATH_H */
