/*
**	IDT_int_hand.c - contains code for handling external interrupts 
**
**	Copyright 1990 Integrated Device Technology, Inc.
**
*/

#include "idtcpu.h" 
#include "setjmp.h"
#include "fpip.h"


#define	PGSIZE	(4*1024)
#define PGOFSET	(PGSIZE-1)


extern	unsigned end;		/* defined by linker */

int extern_int();		/* func. declaration */
int spurious_int();		/* func. declaration */

volatile int *except_ptr;  	/* ptr used by exc hdlr; jmp buf addr | 0 */
static jmp_buf fault_buf;	/* place to save setjmp/longjmp stuff */
volatile int *lastip;


/*
** external interrupt dispatch table When using the add_ext_int_func() 
**		the level argument is the # shown in the table below 
**		as 'level' ( ie ext int 3 is level 5 )
*/
int (*dispatch_tab[8])() = {
	spurious_int,		/* software interrupt 0 level(0)*/
	spurious_int,		/* software interrupt 1	level(1)*/
	spurious_int,		/* external interrupt 0	level(2)*/
	spurious_int,		/* external interrupt 1	level(3)*/
	spurious_int,		/* external interrupt 2	level(4)*/
	spurious_int,		/* external interrupt 3	level(5)*/
	spurious_int,		/* external interrupt 4	level(6)*/
	spurious_int		/* external interrupt 5	level(7)*/
	};

/*
** extern_int() - general dispatcher for external interrupts
**		  There is a dispatch table that various drivers may
**		  modify to install a interrupt function
**
*/
int extern_int(cause,status)
int cause;
int status;
{
	int i,rtn;
	rtn = 0;
	if( (cause & CAUSE_EXCMASK) != 0 )
	   return (0);
	cause &= status;	/* only look at ones that were enabled */
	cause >>= 8;
	for( i = 7 ; i >= 0 ; i-- )	/* extrn 5 is highest priority */
	    if ( cause & ( 1 << i) )
		{ rtn = dispatch_tab[i]();
		  i = -1; }			/* handle only one */
	return(rtn);
}

/***********************************************************************
**
** mem_exc_hdlr() - except_ptr non-zero, must be memory probe
**
**	use longjmp to restore state and return to point of interrupt
**
*************************************************************************/
int mem_exc_hdlr()
{
   volatile int *jbp;

	if (except_ptr)
          {
		jbp = except_ptr;
		except_ptr = 0;
		longjmp(jbp, 1);
	  } 
}


/***********************************************************************
**
** spurious_int() - unexpected external interrupt - don't know how to handle it
**
*************************************************************************/
int spurious_int()
{
	return(0);
}

/*************************************************************************
**
** add_ext_int_func(level,ptrfunc) - install a pointer to a function
**		in the external interrupt dispatch table at interrupt
**		level 'level'.
**
**************************************************************************/
add_ext_int_func(level,ptrfunc)
int level;
int (*ptrfunc)();
{
	dispatch_tab[level] = ptrfunc;
}


/***********************************************************************
**
**  init_tlb()	clear the Translation Lookaside Buffer (TLB)
**
************************************************************************/

void init_tlb()
{
  int i;

	for (i = 0; i < N_TLB_ENTRIES; i++ )
		resettlb(i);
}


/***********************************************************************
**
**  clr_except_ptr()	
**
************************************************************************/

void clr_except_ptr()
{
	except_ptr = 0;
}




/***********************************************************************
**
**  config_memory() - probe memory word by word to determine size	
**
************************************************************************/

int config_memory()
{
   volatile int *ip, mem_size, temp, temp1;
   register int junk;

	if (setjmp(fault_buf))
	   { 
	     except_ptr = 0;
	     mem_size = (K1_TO_PHYS((unsigned)lastip));
	     return(mem_size) ; 
	   }

	except_ptr = fault_buf;
/*
**	look for end of memory 
*/
	for(ip = (int *)(( ((unsigned)(&end + PGSIZE)) | (unsigned)K1BASE) & ~PGOFSET);;ip += PGSIZE/sizeof(*ip)) {
		lastip = ip;
		temp1 = *ip;
		*ip = 0;
		junk += *ip;		/* generate a RBE */
		temp = *(ip+4);		/* just in case it does exist */
		*(ip+4) = 0xaaaa5555;	/* may not generate an RBE */
		junk = *ip;		/* see if memory really */
		junk = *(ip+4);		/* exists - if not return */
		*ip = temp1;
		*(ip+4) = temp;		/* restore just in case */
		if ( junk != 0xaaaa5555 ) /* the end of memory */
		   { except_ptr = 0;
		     mem_size = (K1_TO_PHYS((unsigned)lastip));
		     return(mem_size) ; }
	}
}



/***********************************************************************
**
**  set_except_ptr(jmpbufptr)	
**
************************************************************************/

void set_except_ptr(jbp)
volatile int *jbp;
{
	except_ptr = jbp;
}



/***********************************************************************
**
**  get_except_ptr()	
**
************************************************************************/

volatile int *get_except_ptr()
{
	return(except_ptr);
}



/***********************************************************************
**
** sae_errmsg() - problem interrupt - can't restart - abort 
**
*************************************************************************/
int sae_errmsg()
{
   struct exc_regs regbuf,*regptr;		/* buffer for registers    */

	regptr = &regbuf;
	fpget_excregs(regptr);			/* get all the information */
	printf("\nFloating Point Exception in Branch Delay Slot.\n");
	printf("\nUnrecoverable Error. Exception Registers:\n");

	printf("\n			CAUSE  => %x.\n", regptr->CAUSE_Reg);

	printf("			STATUS => %x.\n", regptr->STATUS_Reg);

	printf("			   EPC => %x.\n", regptr->EPC_Reg);

	printf("			 FPCSR => %x.\n", regptr->FPCSR_Reg);
	
  _exit();
}

