Summary: A CRT screen handling and optimization package.
Name: ncurses
Version: 5.4
%define includedirw %{_includedir}/ncursesw
Release: 13.gnupro.1
License: distributable
Group: System Environment/Libraries
URL: http://dickey.his.com/ncurses/ncurses.html
Source0: ftp://dickey.his.com/ncurses/ncurses-%{version}.tar.bz2
Source1: patch-5.4-20040711.sh
Source2: ncurses-linux
Source3: ncurses-linux-m
Source4: ncurses-resetall.sh
#Source5: term.sh
Patch1: ncurses-5.4-20040718.patch
Patch2: ncurses-5.4-20040724.patch
%if "%{_arch}" == %{_build_arch}
BuildRequires: sharutils
%endif
BuildRoot: %{_tmppath}/%{name}-root

%define _use_cxx "--with-cxx"

%description
The curses library routines are a terminal-independent method of
updating character screens with reasonable optimization.  The ncurses
(new curses) library is a freely distributable replacement for the
discontinued 4.4 BSD classic curses library.

%package devel
Summary: The development files for applications that use ncurses.
Group: Development/Libraries
Requires: ncurses = %{PACKAGE_VERSION}
Obsoletes: ncurses-c++-devel

%description devel
The header files and libraries for developing applications that use
the ncurses CRT screen handling and optimization package.

Install the ncurses-devel package if you want to develop applications
which will use ncurses.

Use the following compiler flags to build against the ncurses library:

-lncurses
(compile and link against the regular ncurses library)

-I %{includedirw} -lncursesw
(compile and link against the wide-character, UTF-8, library)

%prep
%setup -q

/bin/bash %{SOURCE1}

%patch1  -p1 -b .20040718
%patch2  -p1 -b .20040724

%build
CFLAGS="%{optflags} -DPURE_TERMINFO -DSVR4_CURSES"
%define optflags $CFLAGS

#WITH_GPM="--with-gpm"
#WITHOUT_XTERM_NEW="--without-xterm-new"

mkdir narrowc widec
cd narrowc
ln -s ../configure .
%configure --with-shared %{_use_cxx} --without-ada --with-ospeed=unsigned \
   $WITH_GPM --enable-sigwinch --enable-hard-tabs --enable-xmc-glitch \
   --enable-colorfgbg $WITHOUT_XTERM_NEW \
%if "%{_arch}" != %{_build_arch}
   --with-build-cflags='-O2 $(CPPFLAGS)' \
%endif
   --with-install-prefix=${RPM_BUILD_ROOT}
make
cd ../widec
ln -s ../configure .
%configure --with-shared %{_use_cxx} --without-ada --with-ospeed=unsigned \
   $WITH_GPM --enable-sigwinch --enable-hard-tabs --enable-xmc-glitch \
   --enable-colorfgbg $WITHOUT_XTERM_NEW --enable-widec \
%if "%{_arch}" != %{_build_arch}
   --with-build-cflags='-O2 $(CPPFLAGS)' \
%endif
   --with-install-prefix=${RPM_BUILD_ROOT}
make
cd ..

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}%{_libdir}
mkdir -p ${RPM_BUILD_ROOT}%{_datadir}
mkdir -p ${RPM_BUILD_ROOT}%{_includedir}

cd widec
make install includedir=%{_includedir}/ncurses
mkdir -p ${RPM_BUILD_ROOT}%{includedirw}
mv ${RPM_BUILD_ROOT}%{_includedir}/ncurses/* ${RPM_BUILD_ROOT}%{includedirw}
cd ../narrowc
make install includedir=%{_includedir}/ncurses
cd ..

ln -s %{_datadir}/terminfo/l/linux ${RPM_BUILD_ROOT}%{_datadir}/terminfo/c/console
ln -s %{_includedir}/ncurses/curses.h ${RPM_BUILD_ROOT}%{_includedir}/ncurses.h

for header in curses.h unctrl.h eti.h form.h menu.h panel.h term.h
   do ln -sf ncurses/${header} ${RPM_BUILD_ROOT}%{_includedir}/${header}
done

ln -sf libncurses.a ${RPM_BUILD_ROOT}%{_libdir}/libcurses.a
ln -sf libncursesw.a ${RPM_BUILD_ROOT}%{_libdir}/libcursesw.a

%ifarch sparc
install -c -m644 %SOURCE2 ${RPM_BUILD_ROOT}%{_datadir}/terminfo/l/linux
install -c -m644 %SOURCE3 ${RPM_BUILD_ROOT}%{_datadir}/terminfo/l/linux-m
%endif

install -c -m 755 %{SOURCE4} ${RPM_BUILD_ROOT}%{_bindir}/resetall
install -d ${RPM_BUILD_ROOT}%{_sysconfdir}/profile.d
#install -c -m 755 %{SOURCE5} ${RPM_BUILD_ROOT}%{_sysconfdir}/profile.d

rm -f ${RPM_BUILD_ROOT}%{_datadir}/man/man2/key_defined.3x.20030517*
rm -f ${RPM_BUILD_ROOT}%{_datadir}/man/man2/panel.3x.20030517*

%if "%{_arch}" != %{_build_arch}
# We need to do this so that find-debuginfo.sh will strip the shared
# libs.  It only strips executable files.
chmod 755 ${RPM_BUILD_ROOT}%{_libdir}/lib*.so.*
%endif

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc README ANNOUNCE doc/html/announce.html
%attr(755,root,root) %{_libdir}/lib*.so.*
%{_datadir}/terminfo
%{_datadir}/tabset
%{_libdir}/lib*.so
%{_libdir}/terminfo
#%{_sysconfdir}/profile.d/term.sh
%{_bindir}/*
%{_mandir}/man1/*
%{_mandir}/man5/*
%{_mandir}/man7/*

%files devel
%defattr(-,root,root)
%doc test
%doc doc/html/hackguide.html
%doc doc/html/ncurses-intro.html
%doc c++/README*
%{_libdir}/lib*.a
%{_includedir}/ncurses/*.h
%dir %{_includedir}/ncurses
%dir %{_includedir}/ncursesw
%{_includedir}/ncursesw/*.h
%{_includedir}/curses.h
%{_includedir}/ncurses.h
%{_includedir}/eti.h
%{_includedir}/form.h
%{_includedir}/menu.h
%{_includedir}/panel.h
%{_includedir}/term.h
%{_includedir}/unctrl.h
%{_mandir}/man3/*


%clean
rm -rf ${RPM_BUILD_ROOT}

%changelog
* Tue Aug 31 2004 Adrian Havill <havill@redhat.com> 5.4-13
- term.sh can't detect CJK environment; revert
- gt 2.7 behaves better with xterm-new

* Tue Aug  3 2004 Adrian Havill <havill@redhat.com> 5.4-12
- make xterm same as xterm-r6
- detect for "dumb" in term.sh

* Thu Jul 29 2004 Adrian Havill <havill@redhat.com> 5.4-11
- add latest rollup patches and weekly patches
- remove home/end patch, which is now included in latest
  terminfo.src and termcap.src
- add term.sh to /etc/profile.d, reference in /etc/bashrc
- modify term.sh to support rxvt (#122815 comment 93)

* Fri Jul 08 2004 Adrian Havill <havill@redhat.com> 5.4-10
- add home/end mappings to gnome definition (#122815)

* Tue Jul 06 2004 Adrian Havill <havill@redhat.com> 5.4-9.fc3
- n-v-r

* Tue Jul 06 2004 Adrian Havill <havill@redhat.com> 5.4-9.fc2
- n-v-r

* Tue Jul 06 2004 Adrian Havill <havill@redhat.com> 5.4-9
- remove terminfo try-to-please-all xterm hackery; it's now ptty
  and profile's job to point to the correct terminal. (#122815)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sun May 30 2004 Florian La Roche <Florian.LaRoche@redhat.de>
- remove ncurses-c++-devel rpm, all files are also part of ncurses-devel

* Sat May 29 2004 Joe Orton <jorton@redhat.com> 5.4-6
- fix xterm terminfo entry (Hans de Geode, #122815)

* Thu May 06 2004 Adrian Havill <havill@redhat.com> 5.4-5
- remove --with-gpm from configure, as it adds a pkg
  dependency (#122336) and causes too many problems vs its benefits

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Feb 26 2004 Adrian Havill <havill@redhat.com> 5.4-3
- xterm-color is wrong for rh; inverted bs/del (#115499)

* Wed Feb 25 2004 Adrian Havill <havill@redhat.com> 5.4-3
- link "xterm" to "xterm-color" as temp fix for escape problem (#115448)
- remove old zcat for PATCH1

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb 10 2004 Adrian Havill <havill@redhat.com> 5.4-1
- version update to 5.4

* Thu Jan 29 2004 Adrian Havill <havill@redhat.com> 5.3-10
- add /usr/include/ncursesw (#112979)
- allow for non-gzipped man pages during the build process

* Sun Sep 21 2003 Matt Wilson <msw@redhat.com> 5.3-9.3
- remove the elf32/elf64 provides/obsoletes

* Wed Sep 17 2003 Matt Wilson <msw@redhat.com> 5.3-9.2
- rebuild to fix gzipped file md5sums (#91211)

* Thu Sep 11 2003 Adrian Havill <havill@redhat.com> 5.3-9.1
- RHEL bump

* Thu Sep 11 2003 Adrian Havill <havill@redhat.com> 5.3-9
- remove not-so safe-sprintf configure option because the code does
  not appear to be stable enough for some apps. (#103790)

* Wed Aug 20 2003 Adrian Havill <havill@redhat.com> 5.3-8.1
- RHEL bump

* Wed Aug 20 2003 Adrian Havill <havill@redhat.com> 5.3-8
- multilib patch (#91211)

* Mon Aug 11 2003 Adrian Havill <havill@redhat.com> 5.3-7
- fixed the safe sprintf code that was enabled in the previous release
  by the configure parameter. (#101486)

* Mon Jun 16 2003 Elliot Lee <sopwith@redhat.com> 5.3-6.1
- Fix ac25 patch, make it easy to turn off GPM support

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu May 22 2003 Adrian Havill <havill@redhat.com> 5.3-5
- added latest rollup patch with widec/UTF8 centric weekly (20030517)
- added --enable-widec to configure (#86311)
  original work done by Mr. Sam <sam@email-scan.com>
- require sharutils (#86605)
- add gpm, xmc support
- add debug syms back into package
- updated autoconf/configure patch

* Thu Feb  6 2003 Bill Nottingham <notting@redhat.com> 5.3-4
- fix debuginfo package

* Fri Jan 31 2003 Adrian Havill <havill@redhat.com> 5.3-3
- remunged xterm changes from 5.2 patch for 5.3
- updated screen entry (#82951)
- fixed ka3, kb2 and kf0 entries (#77506)

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Jan 22 2003 Adrian Havill <havill@redhat.com> 5.3-1
- upgrade to 5.3 for sake of utf-8, wide chars (#77585 ...)
- spec file summary/desc grammar (#73583)
- add Requires: for c++ devel subpkg (#74002)
- terminfo.src patches no longer needed
- adjust autoconf patch

* Thu Dec 05 2002 Elliot Lee <sopwith@redhat.com> 5.2-29
- Merge in multilib fixes

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Apr  8 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-26
- Remove duplicated files (#62752)
- Don't strip libraries (#60398)
- Remove cbt capability from xterm description (#61077)

* Mon Feb 25 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-25
- Remove bogus man pages
- Remove bool hack, it breaks make menuconfig

* Fri Feb 22 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-24
- Rebuild for glibc 2.3/gcc 3.1

* Fri Feb 22 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-23
- Put the bool type back in for !c++, but leave TRUE/FALSE out

* Thu Feb 21 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-21
- Don't define TRUE/FALSE etc., we don't care about SVR4 compliance and
  it breaks building gdb

* Thu Feb 21 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-20
- Rebuild for glibc 2.3/gcc 3.1

* Thu Feb 21 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-19
- Patchlevel 20020218
- Re-add %{_includedir}/ncurses.h (#60169)

* Tue Feb 12 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-18
- Add C++ bindings (#59751)

* Tue Feb 12 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-17
- Patchlevel 20020209
- Fix zero-substitution of cf_cv_type_of_bool (#59450)
- Fix rebuilding of configure script with autoconf 2.5x

* Thu Jan 31 2002 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-16
- Patchlevel 20020127

* Tue Nov 27 2001 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-14
- Patchlevel 20011124

* Thu Sep 13 2001 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-13
- Sync with patchlevel 20010908

* Fri Jul 20 2001 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-12
- Sync terminfo with termcap 11.0.1-10

* Sun Jun 24 2001 Bernhard Rosenkraenzer <bero@redhat.com> 5.2-11
- Update to patchlevel 20010623, fixes some lynx issues

* Mon Jun 18 2001 Helge Deller <hdeller@redhat.de>
- fixed tput -S segfaulting bug (#44669)
- use _tmppath for BuildRoot:
- Copyright -> License

* Sun Apr 15 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Update to patchlevel 20010407

* Tue Mar  6 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix up some terminfo entries containing includes to
  "/var/tmp/ncurses-root/something" (#30771)

* Wed Feb 22 2001 Harald Hoyer <harald@redhat.de>
- fixed rxvt backspace setting

* Fri Feb  9 2001 Yukihiro Nakai <ynakai@redhat.com>
- Update Japanese kterm patch

* Mon Jan 15 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Update
- Add japanese patch from termcap
- Fix ospeed handling

* Mon Jan  1 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Add libcurses.a -> libncurses.a symlink (RFE #23023)

* Tue Dec 12 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Use --with-ospeed='unsigned int'

* Fri Nov 17 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix alpha and ia64
- Rebuild with gcc 2.96-64

* Thu Nov  2 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 5.2
- Fix typo in man page (Bug #20205)
- update the "screen" terminfo entries to the version supplied with
  screen 3.9.8

* Mon Oct  9 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Update (fixes the "make menuconfig" bug introduced by the security fix)

* Tue Oct  3 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix security problem (possible buffer overrun)

* Fri Aug  4 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- Add the bugfix patches from the ncurses maintainer

* Thu Jul 13 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 5.1

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Mon Jun  5 2000 Matt Wilson <msw@redhat.com>
- *don't ship symlinks from lib*.so.5 to lib*.so.4!
- use FHS macros

* Fri Jun  2 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- rebuild for 7.0
- /usr/share/man
- update URL for patches
- misc. fixes to spec file

* Mon Mar 20 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- use the real library version number
- update to 20000319

* Tue Mar  7 2000 Jeff Johnson <jbj@redhat.com>
- rebuild for sparc baud rates > 38400.

* Fri Feb 18 2000 Preston Brown <pbrown@redhat.com>
- xterm terminfo entries from XFree86 3.3.6
- final round of xterm fixes, follow debian policy.

* Sat Feb  5 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- strip libraries

* Thu Feb  3 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- More xterm fixes (Bug #9087)

* Thu Jan 27 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- More xterm fixes from Hans de Goede (Bug #8633)

* Sat Jan 15 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- remove some broken symlinks (leftovers from libncurses.so.5)
- Use %configure (Bug #8484)

* Tue Jan 11 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- Add xterm patch from Hans de Goede <hans@highrise.nl>
- Patch 20000108, this fixes a problem with a header file.

* Wed Jan  5 2000 Bernhard Rosenkrnzer <bero@redhat.com>
- Add 20000101 patch, hopefully finally fixing the xterm description

* Wed Dec 22 1999 Cristian Gafton <gafton@redhat.com>
- revert to the old major number - because the ABI is not changed (and we
  should be handling the changes via symbol versioning anyway)

* Fri Nov 12 1999 Bernhard Rosenkraenzer <bero@redhat.com>
- Fix a typo in spec
- Add the 19991006 patch, fixing some C++ STL compatibility problems.
- get rid of profiling and debugging versions - we need to save space...

* Thu Nov  4 1999 Bernhard Rosenkraenzer <bero@redhat.com>
- 5.0
- some spec cleanups to make updating easier
- add links *.so.5 to *.so.4 - they are fully binary compatible.
  (Why did they change the invocation number???)

* Wed Sep 22 1999 Cristian Gafton <gafton@redhat.com>
- make clean in the test dir - don't ship any binaries at all.

* Mon Sep 13 1999 Preston Brown <pbrown@redhat.com>
- fixed stripping of test programs.

* Sun Aug 29 1999 Preston Brown <pbrown@redhat.com>
- removed 'flash' capability for xterm; see bug #2820 for details.

* Fri Aug 27 1999 Cristian Gafton <gafton@redhat.com>
- add the resetall script from Marc Merlin <marc@merlins.org>

* Fri Aug 27 1999 Preston Brown <pbrown@redhat.com>
- added iris-ansi-net as alias for iris-ansi (bug #2561)

* Fri Jul 30 1999 Michael K. Johnson <johnsonm@redhat.com>
- added ncurses-intro.hmtl and hackguide.html to -devel package [bug #3929]

* Tue Apr 06 1999 Preston Brown <pbrown@redhat.com>
- make sure ALL binaries are stripped (incl. test binaries)

* Thu Mar 25 1999 Preston Brown <pbrown@redhat.com>
- made xterm terminfo stuff MUCH better.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 16)

* Sat Mar 13 1999 Cristian Gafton <gafton@redhat.com>
- fixed header for C++ compiles

* Fri Mar 12 1999 Jeff Johnson <jbj@redhat.com>
- add terminfo entries for linux/linux-m on sparc (obsolete termfile_sparc).

* Thu Feb 18 1999 Cristian Gafton <gafton@redhat.com>
- updated patchset from original site

* Thu Dec 03 1998 Cristian Gafton <gafton@redhat.com>
- don't build the C++ demo code
- update patch set to the current as of today (redid all the individual
  patches in a single one)

* Wed Oct 14 1998 Cristian Gafton <gafton@redhat.com>
- make sure to strip the binaries

* Wed Sep 23 1998 Cristian Gafton <gafton@redhat.com>
- added another zillion of patches. The spec file *is* ugly
- defattr

* Mon Jul 20 1998 Cristian Gafton <gafton@redhat.com>
- added lots of patches. This spec file is starting to look ugly

* Wed Jul 01 1998 Alan Cox <alan@redhat.com>
- Fix setuid trusting. Open termcap/info files as the real user.

* Wed May 06 1998 Cristian Gafton <gafton@redhat.com>
- added terminfo entry for the poor guys using lat1 and/or lat-2 on their
  consoles... Enjoy linux-lat ! Thanks, Erik !

* Tue Apr 21 1998 Cristian Gafton <gafton@redhat.com>
- new patch to get xterm-color and nxterm terminfo entries
- aliased them to rxvt, as that seems to satisfy everybody

* Sun Apr 12 1998 Cristian Gafton <gafton@redhat.com>
- added %clean section

* Tue Apr 07 1998 Cristian Gafton <gafton@redhat.com>
- removed /usr/lib/terminfo symlink - we shouldn't need that

* Mon Apr 06 1998 Cristian Gafton <gafton@redhat.com>
- updated to 4.2 + patches
- added BuildRoot

* Sat Apr 04 1998 Cristian Gafton <gafton@redhat.com>
- rebuilt with egcs on alpha

* Wed Dec 31 1997 Erik Troan <ewt@redhat.com>
- version 7 didn't rebuild properly on the Alpha somehow -- no real changes
  are in this version

* Tue Dec 09 1997 Erik Troan <ewt@redhat.com>
- TIOCGWINSZ wasn't used properly

* Tue Jul 08 1997 Erik Troan <ewt@redhat.com>
- built against glibc, linked shared libs against -lc

