;; DFA-based pipeline description for the RM9000.
;;   Copyright (C) 2003, 2004 Free Software Foundation, Inc.
;;
;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the
;; Free Software Foundation, 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

(define_automaton "rm9k_main, rm9k_imul, rm9k_fdiv")

;; These units are for insns that can issue in either pipe.  We don't
;; want to use constructs like "rm9k_m | rm9k_f_int" since that would
;; needlessly make an insn prefer the M pipe.
(define_cpu_unit "rm9k_any1" "rm9k_main")
(define_cpu_unit "rm9k_any2" "rm9k_main")

;; F and M pipe units, for instructions that must be issued by a
;; particular pipe.  Split the F pipe into two units so that integer
;; instructions can issue while the FPU is busy.  We don't need to
;; split M because it is only ever reserved for a single cycle.
(define_cpu_unit "rm9k_m" "rm9k_main")
(define_cpu_unit "rm9k_f_int" "rm9k_main")
(define_cpu_unit "rm9k_f_float" "rm9k_main")

(exclusion_set "rm9k_f_int" "rm9k_f_float")

;; Multiply/divide units.
(define_cpu_unit "rm9k_imul" "rm9k_imul")
(define_cpu_unit "rm9k_fdiv" "rm9k_fdiv")

(define_insn_reservation "rm9k_load" 3
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "load,fpload,fpidxload"))
  "rm9k_m")

(define_insn_reservation "rm9k_store" 1
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "store,fpstore,fpidxstore"))
  "rm9k_m")

(define_insn_reservation "rm9k_int" 1
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "arith,shift,slt,clz,const,nop,trap"))
  "rm9k_any1 | rm9k_any2")

(define_insn_reservation "rm9k_int_cmove" 2
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "condmove")
	    (eq_attr "mode" "SI,DI")))
  "rm9k_any1 | rm9k_any2")

;; This applies to both 'mul' and 'mult'.
(define_insn_reservation "rm9k_mulsi" 3
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "imul,imadd")
	    (eq_attr "mode" "!DI")))
  "rm9k_f_int")

(define_insn_reservation "rm9k_muldi" 7
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "imul,imadd")
	    (eq_attr "mode" "DI")))
  "rm9k_f_int + rm9k_imul * 7")

(define_insn_reservation "rm9k_divsi" 38
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "!DI")))
  "rm9k_f_int + rm9k_imul * 38")

(define_insn_reservation "rm9k_divdi" 70
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "idiv")
	    (eq_attr "mode" "DI")))
  "rm9k_f_int + rm9k_imul * 70")

(define_insn_reservation "rm9k_mfhilo" 1
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "mfhilo"))
  "rm9k_f_int")

(define_insn_reservation "rm9k_mthilo" 5
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "mthilo"))
  "rm9k_f_int")

(define_insn_reservation "rm9k_xfer" 2
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "xfer"))
  "rm9k_m")

(define_insn_reservation "rm9k_fquick" 2
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "fabs,fneg,fcmp,fmove"))
  "rm9k_f_float")

(define_insn_reservation "rm9k_fcmove" 2
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "condmove")
	    (eq_attr "mode" "SF,DF")))
  "rm9k_m")

(define_insn_reservation "rm9k_fadd" 6
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "fadd,fcvt"))
  "rm9k_f_float")

(define_insn_reservation "rm9k_fmuls" 6
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "SF")))
  "rm9k_f_float")

(define_insn_reservation "rm9k_fmuld" 9
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "fmul,fmadd")
	    (eq_attr "mode" "DF")))
  "rm9k_f_float * 3")

(define_insn_reservation "rm9k_fdivs" 22
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "fdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "SF")))
  "rm9k_f_float + rm9k_fdiv * 22")

(define_insn_reservation "rm9k_fdivd" 37
  (and (eq_attr "cpu" "r9000")
       (and (eq_attr "type" "fdiv,fsqrt,frsqrt")
	    (eq_attr "mode" "DF")))
  "rm9k_f_float + rm9k_fdiv * 37")

(define_insn_reservation "rm9k_branch" 2
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "branch,jump,call"))
  "rm9k_any1 | rm9k_any2")

(define_insn_reservation "rm9k_unknown" 1
  (and (eq_attr "cpu" "r9000")
       (eq_attr "type" "unknown,multi"))
  "rm9k_m + rm9k_f_int + rm9k_any1 + rm9k_any2")
