/* bug.h: kernel bug reporting
 *
 * Copyright (C) 2005 Red Hat, Inc. All Rights Reserved.
 * Written by David Howells (dhowells@redhat.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */
#ifndef _ASM_BUG_H
#define _ASM_BUG_H

#include <linux/config.h>

/*
 * Tell the user there is some problem.
 */
extern void __do_bug(const char *file, int line, const void *retaddr);

#define BUG()								\
do {									\
	__do_bug(__FILE__, __LINE__, __builtin_return_address(0));	\
} while (0)

#define HAVE_ARCH_BUG
#include <asm-generic/bug.h>

#endif /* _ASM_BUG_H */
