Summary:        Kernel and Hardware related utilities
Name:           kernel-utils
Version:        2.4
Release: 	13.%(R="$Revision: 1.49 $"; RR="${R##: }"; echo ${RR%%?})_FC3
Serial:         1
Group:          System Environment/Base
License:        GPL/OSL
Source0:        microcode_ctl-1.11.tar.gz
Source1:	microcode_ctl.init
Source10:	dmidecode-2.2.tar.gz
Source20: 	smartmontools-5.33.tar.gz
Source30:	smartd.initd
Source31:	smartd-conf.py
Source40: 	rng-tools-2.tar.gz
Source50:	x86info-1.12b.tgz
Source60:	longrun-0.9.tar.bz2
Source70:	salinfo-0.5-rhel4.tar.gz
Source90:	irqbalance-0.12.tar.gz
Source91:	irqbalance.init
Source92:	irqbalance.sysconfig
Source100:	hardlink.c
Source110:	http://carlthompson.net/dl/cpuspeed/cpuspeed-1.1.tar.gz
Source111:	cpuspeed.init
Source120:	readahead.c
Source121:	readahead.init
Source122:	readahead.files
Source123:	readahead_early.init
Source124:	readahead.early.files
Buildroot:      %{_tmppath}/%{name}-%{version}-root
Prereq:		/sbin/chkconfig /sbin/service
Requires:	fileutils kudzu
BuildPreReq: 	readline-devel ncurses-devel /usr/bin/aclocal /usr/bin/automake /usr/bin/autoconf util-linux groff gettext

%ifarch {ix86}
Obsoletes:	microcode_ctl
%endif
Patch1: microcode_ctl.patch
Patch2: smartmontools-smartd.patch
Patch3: cpuspeed.patch
Patch4: irqbalance-pie.patch
Patch5: longrun-0.9-14.patch
Patch6: rng-tools-2-devname.patch
Patch7: cpuspeed-smp.patch

%description
kernel-utils contains several utilities that can be used to control
the kernel or your machines hardware. Included are
* cpuspeed - dynamically change the speed of CPUs (if CPU is capable)
* dmidecode - gives information about the bios and motherboard revisions
* irqbalance - Evenly distribute interrupt load across CPUs.
* microcode_ctl - updates the microcode on Intel cpus
* rng-tools - Hardware random number generation tools.
* smartctl - monitor the health of your disks


%prep
%setup -q -c -a 0 -a 10 -a 20 -a 40 -a 50 -a60 -a70 -a90 -a110

%patch1
# %patch2 -p0
%patch3 -p0
%patch4 -p1
%patch5 -p0
%patch6 -p0
%patch7 -p0

%build
rm -rf $RPM_BUILD_ROOT

mkdir -p %{buildroot}/usr/sbin
mkdir -p %{buildroot}/usr/man
mkdir -p %{buildroot}/etc/rc.d/init.d
mkdir -p %{buildroot}/etc/sysconfig

%ifarch %{ix86} x86_64
cd microcode_ctl-1.11
make CFLAGS="$RPM_OPT_FLAGS"
cd ..
%endif

cd rng-tools-2
%configure --sbindir=/sbin
make
cd ..

%ifarch ia64
cd salinfo-0.5-rhel4
make
cd ..
%endif

cd cpuspeed-1.1
make CFLAGS="$RPM_OPT_FLAGS -fpie -pie -Wl,-z,relro,-z,now"
cd ..

cd dmidecode-2.2
make
cd ..

%install
mkdir -p %{buildroot}/usr/share/man/man{1,8}


%ifarch %{ix86} x86_64
cd microcode_ctl-1.11

make DESTDIR=$RPM_BUILD_ROOT PREFIX=%{_prefix} \
     INSDIR=/sbin MANDIR=%{_mandir}/man8 RCDIR=/etc MICDIR=/etc/firmware install clean

install %{SOURCE1} %{buildroot}/etc/rc.d/init.d/microcode_ctl
rm %{buildroot}/etc/init.d/microcode_ctl
cd ..
%endif

%ifarch %{ix86}
cd x86info-1.12b
make
install x86info %{buildroot}/usr/sbin/x86info
install x86info.1 %{buildroot}/usr/share/man/man1/

cd ../longrun
make
install longrun %{buildroot}/usr/sbin
install longrun.1 %{buildroot}/usr/share/man/man1
cd ..
%endif

cd cpuspeed-1.1
install cpuspeed %{buildroot}/usr/sbin
install %{SOURCE111} %{buildroot}/etc/rc.d/init.d/cpuspeed
install cpuspeed.conf %{buildroot}/etc/cpuspeed.conf
cd ..

cd smartmontools-5.33
%configure
make CFLAGS="$RPM_OPT_FLAGS -fpie -pie -Wl,-z,relro,-z,now" DESTDIR=$RPM_BUILD_ROOT smartd smartctl install
rm -f %{buildroot}/etc/smartd.conf
rm -f %{buildroot}/etc/rc.d/init.d/smartd.conf
install %{SOURCE30} %{buildroot}/etc/rc.d/init.d/smartd

cd ../irqbalance
make
install irqbalance  %{buildroot}/usr/sbin
install %{SOURCE91} %{buildroot}/etc/rc.d/init.d/irqbalance
install %{SOURCE92} %{buildroot}/etc/sysconfig/irqbalance
install irqbalance.1 %{buildroot}/usr/share/man/man1/

%ifarch %{ix86} x86_64 ia64
cd ../dmidecode-2.2
install dmidecode %{buildroot}/usr/sbin
%endif

cd ../rng-tools-2
make DESTDIR=$RPM_BUILD_ROOT install

gcc -Wall -O2 -g %{SOURCE100} -o %{buildroot}/usr/sbin/hardlink
gcc -Wall -O2 -g %{SOURCE120} -o %{buildroot}/usr/sbin/readahead
install %{SOURCE121} %{buildroot}/etc/rc.d/init.d/readahead
install %{SOURCE122} %{buildroot}/etc/readahead.files
install %{SOURCE123} %{buildroot}/etc/rc.d/init.d/readahead_early
install %{SOURCE124} %{buildroot}/etc/readahead.early.files
install %{SOURCE31} %{buildroot}/usr/sbin/smartd-conf.py

%ifarch ia64
cd ../salinfo-0.5-rhel4
make install prefix=%{buildroot} mandir=%{_mandir} sbindir=%{_sbindir} initdir=%{_sysconfdir}/rc.d/init.d logdir=/var/log/salinfo
%endif

chmod -R a-s %{buildroot}
%clean
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;

%files
%defattr(-,root,root)
%ifarch %{ix86} x86_64
/etc/rc.d/init.d/microcode_ctl
/etc/firmware/*
/sbin/microcode_ctl
%endif
%ifarch %{ix86}
/usr/sbin/x86info
/usr/sbin/longrun
%endif
/usr/sbin/cpuspeed
/etc/rc.d/init.d/cpuspeed
%attr(0644,root,root) %config /etc/cpuspeed.conf
%attr(0644,root,root) /etc/readahead.files
%attr(0644,root,root) /etc/readahead.early.files
/usr/sbin/irqbalance
/usr/sbin/hardlink
/usr/sbin/readahead
%attr(0644,root,root) %{_mandir}/*/*
/usr/sbin/smartd
/usr/sbin/smartctl
/usr/sbin/smartd-conf.py
/etc/rc.d/init.d/smartd
/etc/rc.d/init.d/irqbalance
/etc/rc.d/init.d/readahead
/etc/rc.d/init.d/readahead_early
%attr(0644,root,root) /etc/sysconfig/irqbalance
%ifarch %{ix86} ia64 x86_64
/usr/sbin/dmidecode
%endif
%doc /usr/share/doc/smartmontools-5.33
/usr/bin/rngtest
/sbin/rngd
%ifarch ia64
%doc %{_mandir}/man8/salinfo_decode.8.gz
%{_sbindir}/salinfod
%{_sbindir}/salinfo_decode2
%{_sbindir}/salinfo_decode
%attr(0755,root,root) %{_sysconfdir}/rc.d/init.d/salinfod
%dir /var/log/salinfo
%dir /var/log/salinfo/raw
%dir /var/log/salinfo/decoded
%endif

%preun
if [ "$1" = "0" ] ; then
 /sbin/service smartd stop
 /sbin/chkconfig --del smartd
 /sbin/chkconfig --del readahead
 /sbin/chkconfig --del readahead_early
 /sbin/chkconfig --del cpuspeed
%ifarch %{ix86} x86_64
 /sbin/chkconfig --del irqbalance
 /sbin/chkconfig --del microcode_ctl
%endif
%ifarch ia64
 /sbin/service salinfod stop
 /sbin/chkconfig --del salinfod
%endif
fi

%post
/sbin/chkconfig --add smartd
/sbin/chkconfig --add readahead
/sbin/chkconfig --add readahead_early
/sbin/chkconfig --add cpuspeed
%ifarch %{ix86} x86_64
/sbin/chkconfig --add irqbalance
/sbin/chkconfig --add microcode_ctl
%endif
%ifarch ia64
/sbin/chkconfig --add salinfod
%endif

%changelog
* Tue Jan 18 2005 Dave Jones <davej@redhat.com>
- Update microcode_ctl to 1.11

* Sun Nov 28 2004 Dave Jones <davej@redhat.com>
- Don't use binaries from /usr too early. (#102049)
- Fix bogus "" in microcode_ctl initscript. (#112014)

* Thu Nov  4 2004 Dave Jones <davej@redhat.com>
- Update irqbalance to 1.12 (#130625)

* Sat Oct 30 2004 Dave Jones <davej@redhat.com>
- Install irqbalance manpage. (#90023)

* Fri Oct 29 2004 Dave Jones <davej@redhat.com>
- Update irqbalanced (#137136)
- Don't start microcode_ctl with -i any more
- Remove reference to IA32 in microcode startup,
  as it works on EM64T now too.
- Update microcode_ctl to upstream 1.10 (#134017, #134018)

* Thu Oct 28 2004 Dave Jones <davej@redhat.com>
- Start irqbalanced on x86-64 too. (#137507)
- chkconfig -del readaheady early on uninstall.

* Wed Oct 20 2004 Miloslav Trmac <mitr@redhat.com>
- Add Requires: kudzu for smartd-conf.py (#134056)

* Mon Oct 18 2004 Dave Jones <davej@redhat.com>
- SMP support for cpuspeed (#134398)

* Tue Oct 12 2004 Dave Jones <davej@redhat.com>
- Re-add dmidecode.
- Include upstream microcode_ctl patch for x86-64.

* Mon Oct 11 2004 Dave Jones <davej@redhat.com>
- Add salinfod for ia64. (#133268)
- Enable microcode_ctl for x86-64

* Wed Sep 15 2004 Arjan van de Ven <arjanv@redhat.com>
- refresh smartmontools

* Mon Sep 13 2004 Arjan van de Ven <arjanv@redhat.com>
- fix missing buildreqs from bug 132410

* Wed Aug 18 2004 Bill Nottingham <notting@redhat.com>
- move rngd to /sbin
- patch rngd to use /dev/hw_crypto by default, not /dev/hwcrypto

* Tue Jun 29 2004 Arjan van de Ven <arjanv@redhat.com>
- add rng-tools

* Mon Jun 21 2004 Alan Cox <alan@redhat.com>
- Fix #107453

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue May 11 2004 Arjan van de Ven <arjanv@redhat.com>
- remove dmidecode; the 2.6 kernel exports the info in sysfs
- include cpuspeed on all architectures

* Fri May 07 2004 Arjan van de Ven <arjanv@redhat.com>
- fix for bug 122677 (cpuspeed initscript borkage)

* Mon May 03 2004 Arjan van de Ven <arjanv@redhat.com>
- add fix for bug 120522
* Sun May 02 2004 Arjan van de Ven <arjanv@redhat.com>
- update smartmontools to prevent amd64 from segfaulting

* Sat Apr 17 2004 Arjan van de Ven <arjanv@redhat.com>
- make cpuspeed initscript honor locking

* Thu Apr 08 2004 Arjan van de Ven <arjanv@redhat.com>
- fix bug #120347

* Tue Mar 30 2004 Karsten Hopp <karsten@redhat.de> 2.4-9.1
- fix permissions of config files and man pages (#116243)

* Sat Mar 20 2004 Arjan van de Ven <arjanv@redhat.com>
- add patch from warren to make cpuspeed less verbose during boot

* Sun Jan 18 2004 Arjan van de Ven <arjanv@redhat.com>
- add readahead

* Wed Dec 10 2003 Arjan van de Ven <arjanv@redhat.com>
- make irqbalance a PIE executable

* Sun Nov 09 2003 Arjan van de Ven <arjanv@redhat.com>
- add cpuspeed

* Mon Oct 20 2003 Arjan van de Ven <arjanv@redhat.com> 2.4.8-39
- update smartmontools to version 5.21

* Thu Oct 16 2003 Arjan van de Ven <arjanv@redhat.com> 2.4.8-38
- add /usr/bin/hardlink

* Mon Sep 08 2003 Arjan van de Ven <arjanv@redhat.com> 2.4.8-36
- update smartmontools to a 64 bit clean version
- update irqbalance

* Thu Aug 21 2003 Arjan van de Ven <arjanv@redhat.com> 2.4.8-35
- update dmidecode

* Tue Jul 29 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.33
- disable smartd by default

* Thu Jul 03 2003 Arjan van de Ven <arjanv@redhat.com>
- clean up the spec a bit
- drop cpqarray monitor; too many dependencies for the use it gets

* Mon Jun 02 2003 Arjan van de Ven <arjanv@redhat.com>
- switch to smartmontools for SMART monitoring

* Fri May 02 2003 Arjan van de Ven <arjanv@redhat.com>
- add chstk for setting non-exec stack flags

* Wed Jan 22 2003 Michael K. Johnson <johnsonm@redhat.com> 2.4-8.28
- /etc/sysconfig/irqbalance to set --oneshot from config file

* Sun Jan 19 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.26
- updated irqbalance code

* Sat Jan 18 2003 Arjan van de Ven <arjanv@redhat.com> 2.4-8.23
- add initial irqbalance code

* Thu Jan 16 2003 Bill Nottingham <notting@redhat.com> 2.4-8.22
- fix %%post/%%preun on non-x86

* Tue Jan  7 2003 Nalin Dahyabhai <nalin@redhat.com> 2.4-8.21
- Rebuild

* Fri Dec 13 2002 Elliot Lee <sopwith@redhat.com> 2.4-8.20
- Build on all archs

* Thu Dec 12 2002 Michael K. Johnson <johnsonm@redhat.com> 2.4-8.19
- added report-acpi-bug script

* Tue Dec 03 2002 Arjan van de Ven <arjanv@redhat.com> 2.4-8.18
- update x86info to version 1.11
- include pmtools for acpi disasm

* Fri Nov 15 2002 Michael K. Johnson <johnsonm@redhat.com> 2.4-8.17
- HP hasn't said it is shipping hammer, so no need for cpqarrayd on hammer
- uml is x86-only for now -- should probably move to its own package
- deal with new net-snmp additional #include requirements

* Thu Nov 14 2002 Michael K. Johnson <johnsonm@redhat.com> 2.4-8.15
- Added acpidmp for x86 only for now (has x86-specific bits in it)
- Updated package cruft removal

* Thu Sep 12 2002 Guy Streeter <streeter@redhat.com> 2.4-8.14
- No eepro100-diag for ppc.

* Fri Aug 23 2002 Elliot Lee <sopwith@redhat.com> 2.4-8.13
- Don't cop out of building uml_net on ia64 - instead, remove usage of
  (effect-free) SA_NOCLDWAIT if not defined.
- Include all the uml tools (+ jailtest/uml_moo/uml_switch/uml_watchdog)

* Fri Aug 23 2002 Arjan van de Ven <arjanv@redhat.com> 2.4-8.12
- add uml tools

* Wed Aug 21 2002 Elliot Lee <sopwith@redhat.com> 2.4-8.11
- Remove ExclusiveArch: i386 (since it builds everywhere)
- Include smartd/smartctl man pages

* Wed Jul 31 2002 Arjan van de Ven <arjanv@redhat.com>
- added longrun uitility

* Thu Jun 27 2002 Elliot Lee <sopwith@redhat.com> 2.4-8.7
- Patch31 for net-snmp 

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu Jun 20 2002 Michael K. Johnson <johnsonm@redhat.com>
- include the man pages

* Sat Mar 30 2002	Arjan van de Ven <arjanv@redhat.com>
- change initorder to not shut services down after NFS has shut down
  to allow /usr to be NFS mounted

* Wed Mar 20 2002	Arjan van de Ven <arjanv@redhat.com>
- fix microcode_ctl to work on smp

* Thu Mar 14 2002 Bill Nottingham <notting@redhat.com> 2.4-5
- don't run things by default

* Wed Feb  6 2002 Tim Powers <timp@redhat.com> 2.4-3.6.2
- fix %%post sciptlet typo

* Mon Feb 04 2002	Arjan van de Ven <arjanv@redhat.com>
- fail gracefully in microcode_ctl if firmware isn't downloaded

* Mon Jan 28 2002	Arjan van de Ven <arjanv@redhat.com>
- added x86info

* Tue Jan 15 2002       Bill Nottingham <notting@redhat.com>
- move eepro100-diag from kudzu to here

* Fri Jan 11 2002	Arjan van de Ven <arjanv@redhat.com>
- added cpqarrayd for monitoring cpqarray drives too
  from http://starbreeze.knoware.nl/~hugo/compaq/

* Mon Jan 07 2002	Arjan van de Ven <arjanv@redhat.com>
- added smartsuite for monitoring disk health status

* Fri Dec 07 2001	Arjan van de Ven <arjanv@redhat.com>
- Initial packaging
