# this file contains rule variables that tell cmake how to 
# do things like build a .o file, create a shared or static library
#

# this file defines the following rule variables
# CMAKE_CXX_CREATE_SHARED_LIBRARY
# CMAKE_CXX_CREATE_SHARED_MODULE
# CMAKE_C_CREATE_SHARED_LIBRARY
# CMAKE_C_CREATE_SHARED_MODULE
# CMAKE_CXX_CREATE_STATIC_LIBRARY
# CMAKE_C_CREATE_STATIC_LIBRARY
# CMAKE_CXX_COMPILE_OBJECT
# CMAKE_C_COMPILE_OBJECT
# CMAKE_C_LINK_EXECUTABLE
# CMAKE_CXX_LINK_EXECUTABLE

# variables supplied by the generator at use time
# <TARGET>
# <TARGET_BASE> the target without the suffix
# <OBJECTS>
# <OBJECT>
# <LINK_LIBRARIES>
# <FLAGS>
# <LINK_FLAGS>

# CXX compiler information
# <CMAKE_CXX_COMPILER>  
# <CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS>
# <CMAKE_CXX_SHARED_MODULE_CREATE_FLAGS>
# <CMAKE_CXX_LINK_FLAGS>

# C compiler information
# <CMAKE_C_COMPILER>  
# <CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS>
# <CMAKE_SHARED_MODULE_CREATE_C_FLAGS>
# <CMAKE_C_LINK_FLAGS>

# Static library tools
# <CMAKE_AR> 
# <CMAKE_RANLIB>


# create a shared C++ library
IF(NOT CMAKE_CXX_CREATE_SHARED_LIBRARY)
  SET(CMAKE_CXX_CREATE_SHARED_LIBRARY
      "<CMAKE_CXX_COMPILER> <CMAKE_SHARED_LIBRARY_CXX_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_CXX_FLAGS> <CMAKE_SHARED_LIBRARY_SONAME_CXX_FLAG><TARGET_SONAME> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")
ENDIF(NOT CMAKE_CXX_CREATE_SHARED_LIBRARY)

IF(CMAKE_COMPILER_IS_GNUCXX)
  SET(CMAKE_CXX_CREATE_SHARED_LIBRARY "${CMAKE_CXX_CREATE_SHARED_LIBRARY} -lgcc")
ENDIF(CMAKE_COMPILER_IS_GNUCXX)

# create a c++ shared module copy the shared library rule by default
IF(NOT CMAKE_CXX_CREATE_SHARED_MODULE)
  SET(CMAKE_CXX_CREATE_SHARED_MODULE ${CMAKE_CXX_CREATE_SHARED_LIBRARY})
ENDIF(NOT CMAKE_CXX_CREATE_SHARED_MODULE)

# create a C shared library
IF(NOT CMAKE_C_CREATE_SHARED_LIBRARY)
  SET(CMAKE_C_CREATE_SHARED_LIBRARY
      "<CMAKE_C_COMPILER> <CMAKE_SHARED_LIBRARY_C_FLAGS> <LINK_FLAGS> <CMAKE_SHARED_LIBRARY_CREATE_C_FLAGS> <CMAKE_SHARED_LIBRARY_SONAME_C_FLAG><TARGET_SONAME> -o <TARGET> <OBJECTS> <LINK_LIBRARIES>")
ENDIF(NOT CMAKE_C_CREATE_SHARED_LIBRARY)

# create a C shared module just copy the shared library rule
IF(NOT CMAKE_C_CREATE_SHARED_MODULE)
  SET(CMAKE_C_CREATE_SHARED_MODULE ${CMAKE_C_CREATE_SHARED_LIBRARY})
ENDIF(NOT CMAKE_C_CREATE_SHARED_MODULE)

# create a C++ static library
IF(NOT CMAKE_CXX_CREATE_STATIC_LIBRARY)
  SET(CMAKE_CXX_CREATE_STATIC_LIBRARY
      "<CMAKE_AR> cr <TARGET> <LINK_FLAGS> <OBJECTS> "
      "<CMAKE_RANLIB> <TARGET> ")
ENDIF(NOT CMAKE_CXX_CREATE_STATIC_LIBRARY)

# create a C static library
IF(NOT CMAKE_C_CREATE_STATIC_LIBRARY)
  SET(CMAKE_C_CREATE_STATIC_LIBRARY
      "<CMAKE_AR> cr <TARGET> <LINK_FLAGS> <OBJECTS> "
      "<CMAKE_RANLIB> <TARGET> ")
ENDIF(NOT CMAKE_C_CREATE_STATIC_LIBRARY)

# compile a C++ file into an object file
IF(NOT CMAKE_CXX_COMPILE_OBJECT)
  SET(CMAKE_CXX_COMPILE_OBJECT
    "<CMAKE_CXX_COMPILER> -o <OBJECT> <FLAGS> -c <SOURCE>")
ENDIF(NOT CMAKE_CXX_COMPILE_OBJECT)

# compile a C file into an object file
IF(NOT CMAKE_C_COMPILE_OBJECT)
  SET(CMAKE_C_COMPILE_OBJECT
    "<CMAKE_C_COMPILER> -o <OBJECT>  <FLAGS> -c <SOURCE>")
ENDIF(NOT CMAKE_C_COMPILE_OBJECT)


IF(NOT CMAKE_C_LINK_EXECUTABLE)
  SET(CMAKE_C_LINK_EXECUTABLE
    "<CMAKE_C_COMPILER> <CMAKE_C_LINK_FLAGS> <LINK_FLAGS> <FLAGS> <OBJECTS>  -o <TARGET> <LINK_LIBRARIES>")
ENDIF(NOT CMAKE_C_LINK_EXECUTABLE)


IF(NOT CMAKE_CXX_LINK_EXECUTABLE)
  SET(CMAKE_CXX_LINK_EXECUTABLE
    "<CMAKE_CXX_COMPILER> <CMAKE_CXX_LINK_FLAGS> <LINK_FLAGS> <FLAGS> <OBJECTS>  -o <TARGET> <LINK_LIBRARIES>")
ENDIF(NOT CMAKE_CXX_LINK_EXECUTABLE)
