/*
**	timer_int_hand.c - contains code for controlling the timer
**			interrupts and for handling external interrupts
**			in general
**
**	Copyright 1990 Integrated Device Technology, Inc.
**
*/
#include "idtmon.h"
#include "idtio.h"
#include "i8254.h"
#define INT_LEVEL 2

int timer_int();		/* func. declaration */

int tim_fd;		/* file descritor for timer 0            */
unsigned current_time;	/* current time -  real time clock       */

/*-----------------------------------------------------------------------
**	time_cmd_init() - starts off the clock  - opens timer0 and sets up the
**		     interrupt pointer to the real time clock interrupt
**		     routine.
*/
int time_cmd_init(int_level,resolution)
int int_level;
int resolution;
{
	current_time = 0;
	tim_fd = open("timer0", O_RDWR );
	if ( tim_fd == -1)
	  { printf("Can't open timer0\n");
	    return(FALSE); }
	add_ext_int_func(int_level+2,timer_int);
	ioctl(tim_fd,CIOCMODE2,resolution);  /* interrupt every res. ms */
	ioctl(tim_fd,CIOCINTENAB,int_level); 	/* enable interrupt */	
	return(TRUE);
}

/*
** time_init(addr,int_level,resolution) - initialize timer driver and time
**			funcion
**	entry:
**		addr	timer base address
**		int_level	external interrupt line
**		resolution	number of ms per clock increment
**
*/
time_init(addr,int_level,resolution)
int addr;
int int_level;
int resolution;
{
	install_timer_driver(addr);
	time_cmd_init(int_level,resolution);
}


/*
** timer_int - real time clock interrupt routine - called with interrupts
**		disabled - must clear the hardware interrupt before
**		turning interrupts back on. Get here via the interrupt
**		dispatch table.
*/
int timer_int()
{
	volatile int i;
	i = ioctl(tim_fd,CIOCCLRINT,0);	/* clear hardware interrupt */
	current_time++;
	return(TRUE);
}
/*
** time();
*/
time(tloc)
int *tloc;
{
	if(tloc != NULL)
	   *tloc = current_time;
	return((int)current_time);
}

/*
** time_it(ptr_func) - times the function pointed to by ptr_func
**	entry:
**		unsigned (*ptr_func)();  - pointer to the function to time
**	returns:
**		unsigned time in number of clock ticks * loop_cnt 
*/
unsigned time_it(ptr_func,loop_cnt)
unsigned (*ptr_func)();
int loop_cnt;
{
	unsigned t,elapsed_time;
	int i;

	if( loop_cnt < 1 )
	   { printf("loop count must be greater than one\n");
	     return(0); }
	t = current_time;
	for(i=0; i<loop_cnt; i++)
		ptr_func();
	elapsed_time = current_time -t;
	return(elapsed_time);
}

