/*
   (c) Copyright 2002-2003  Denis Oliver Kropp <dok@directfb.org>
   All rights reserved.

   XDirectFB is mainly based on XDarwin and
   also contains some KDrive, XFree and XWin code.
*/

/* $XFree86: xc/programs/Xserver/hw/directfb/directfbKeyboard.c,v 1.15 2002/02/07 02:54:44 torrey Exp $ */

/*
===========================================================================

 An X keyCode must be in the range XkbMinLegalKeyCode (8) to
 XkbMaxLegalKeyCode(255).

 The keyCodes we get from the kernel range from 0 to 127, so we need to
 offset the range before passing the keyCode to X.

 An X KeySym is an extended ascii code that is device independent.

 The modifier map is accessed by the keyCode, but the normal map is
 accessed by keyCode - MIN_KEYCODE.  Sigh.

===========================================================================
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <X11/keysym.h>
#include "directfbX.h"
#include "directfbScreen.h"
#include "directfbKeyboard.h"

int       directfbMouseButtonCount;
int       directfbMinScanCode;
int       directfbMaxScanCode;
int       directfbMinKeyCode;
int       directfbMaxKeyCode;
int       directfbKeymapWidth = DIRECTFB_MAX_WIDTH;
CARD8          directfbModMap[MAP_LENGTH];
KeySymsRec     directfbKeySyms;

KeySym         directfbKeymap[DIRECTFB_MAX_LENGTH * DIRECTFB_MAX_WIDTH] = { 0};

/* This table assumes an iso8859_1 encoding for the characters 
 * > 80, as returned by pccons */
static KeySym latin1_to_x[256] = {
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     XK_BackSpace,  XK_Tab,        XK_Linefeed,   NoSymbol,
     NoSymbol, XK_Return,     NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     XK_Cancel,     NoSymbol, NoSymbol, XK_Escape,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     XK_space, XK_exclam,     XK_quotedbl,   XK_numbersign,
     XK_dollar,     XK_percent,    XK_ampersand,  XK_apostrophe,
     XK_parenleft,  XK_parenright, XK_asterisk,   XK_plus,
     XK_comma, XK_minus, XK_period,     XK_slash,
     XK_0,          XK_1,          XK_2,          XK_3,
     XK_4,          XK_5,          XK_6,          XK_7,
     XK_8,          XK_9,          XK_colon, XK_semicolon,
     XK_less,  XK_equal, XK_greater,    XK_question,
     XK_at,         XK_A,          XK_B,          XK_C,
     XK_D,          XK_E,          XK_F,          XK_G,
     XK_H,          XK_I,          XK_J,          XK_K,
     XK_L,          XK_M,          XK_N,          XK_O,
     XK_P,          XK_Q,          XK_R,          XK_S,
     XK_T,          XK_U,          XK_V,          XK_W,
     XK_X,          XK_Y,          XK_Z,          XK_bracketleft,
     XK_backslash,  XK_bracketright,XK_asciicircum,    XK_underscore,
     XK_grave, XK_a,          XK_b,          XK_c,
     XK_d,          XK_e,          XK_f,          XK_g,
     XK_h,          XK_i,          XK_j,          XK_k,
     XK_l,          XK_m,          XK_n,          XK_o,
     XK_p,          XK_q,          XK_r,          XK_s,
     XK_t,          XK_u,          XK_v,          XK_w,
     XK_x,          XK_y,          XK_z,          XK_braceleft,
     XK_bar,        XK_braceright, XK_asciitilde, XK_Delete,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     NoSymbol, NoSymbol, NoSymbol, NoSymbol,
     XK_nobreakspace,XK_exclamdown,     XK_cent,  XK_sterling,
     XK_currency,   XK_yen,        XK_brokenbar,  XK_section,
     XK_diaeresis,  XK_copyright,  XK_ordfeminine,     XK_guillemotleft,
     XK_notsign,    XK_hyphen,     XK_registered, XK_macron,
     XK_degree,     XK_plusminus,  XK_twosuperior,     XK_threesuperior,
     XK_acute, XK_mu,         XK_paragraph,  XK_periodcentered,
     XK_cedilla,    XK_onesuperior,     XK_masculine,  XK_guillemotright,
     XK_onequarter, XK_onehalf,    XK_threequarters,XK_questiondown,
     XK_Agrave,     XK_Aacute,     XK_Acircumflex,     XK_Atilde,
     XK_Adiaeresis, XK_Aring, XK_AE,         XK_Ccedilla,
     XK_Egrave,     XK_Eacute,     XK_Ecircumflex,     XK_Ediaeresis,
     XK_Igrave,     XK_Iacute,     XK_Icircumflex,     XK_Idiaeresis,
     XK_ETH,        XK_Ntilde,     XK_Ograve,     XK_Oacute,
     XK_Ocircumflex,     XK_Otilde,     XK_Odiaeresis, XK_multiply,
     XK_Ooblique,   XK_Ugrave,     XK_Uacute,     XK_Ucircumflex,
     XK_Udiaeresis, XK_Yacute,     XK_THORN, XK_ssharp,
     XK_agrave,     XK_aacute,     XK_acircumflex,     XK_atilde,
     XK_adiaeresis, XK_aring, XK_ae,            XK_ccedilla,
     XK_egrave,     XK_eacute,     XK_ecircumflex,     XK_ediaeresis,
     XK_igrave,     XK_iacute,     XK_icircumflex, XK_idiaeresis,
     XK_eth,        XK_ntilde,     XK_ograve,     XK_oacute,
     XK_ocircumflex,     XK_otilde,     XK_odiaeresis, XK_division,
     XK_oslash,     XK_ugrave,     XK_uacute,     XK_ucircumflex,
     XK_udiaeresis, XK_yacute,     XK_thorn,      XK_ydiaeresis
};

static void
XDirectFBChangeKeyboardControl( DeviceIntPtr device, KeybdCtrl *ctrl )
{
     /* keyclick, bell volume / pitch, autorepead, LED's */
}

static void
XDirectFBBell (int volume, DeviceIntPtr pDev, pointer ctrl, int something)
{
}

const DirectFBKeySymModsRec directfbKeySymMods[] = {
     {  XK_Control_L,  ControlMask},
     {  XK_Control_R, ControlMask},
     {  XK_Shift_L,    ShiftMask},
     {  XK_Shift_R,    ShiftMask},
     {  XK_Caps_Lock,  LockMask},
     {  XK_Shift_Lock, LockMask},
     {  XK_Alt_L, Mod1Mask},
     {  XK_Alt_R, Mod1Mask},
     /*  {  XK_Meta_L,	Mod4Mask },
         {  XK_Meta_R,	Mod4Mask },*/
     {  XK_Num_Lock,   Mod2Mask},
     /*  {  XK_Super_L,	Mod3Mask },
         {  XK_Super_R,	Mod3Mask },
         {  XK_Hyper_L,	Mod3Mask },
         {  XK_Hyper_R,	Mod3Mask },*/
     {  XK_Mode_switch, Mod3Mask},
     {  XK_Scroll_Lock, Mod5Mask},
};

#define NUM_SYM_MODS (sizeof(directfbKeySymMods) / sizeof(directfbKeySymMods[0]))

static void
XDirectFBInitModMap (void)
{
     int     key_code;
     int     row;
     int     i;
     KeySym *syms;

     for (key_code = directfbMinKeyCode; key_code <= directfbMaxKeyCode; key_code++) {
          directfbModMap[key_code] = 0;
          syms = directfbKeymap +
                 (key_code - directfbMinKeyCode) * directfbKeymapWidth;

          for (row = 0; row < directfbKeymapWidth; row++, syms++) {
               for (i = 0; i < NUM_SYM_MODS; i++) {
                    if (*syms == directfbKeySymMods[i].modsym)
                         directfbModMap[key_code] |= directfbKeySymMods[i].modbit;
               }
          }
     }
}

static DFBInputDeviceKeymapSymbolIndex diksi[4] = {
     DIKSI_BASE,
     DIKSI_BASE_SHIFT,
     DIKSI_ALT,
     DIKSI_ALT_SHIFT
};

static KeySym
XDirectFBTranslateSymbol (DFBInputDeviceKeymapEntry *entry, int index)
{
     DFBInputDeviceKeySymbol     symbol = entry->symbols[diksi[index]];
     DFBInputDeviceKeyIdentifier id     = entry->identifier;

     if (id >= DIKI_KP_DIV && id <= DIKI_KP_9) {
          if (symbol >= DIKS_0 && symbol <= DIKS_9)
               return XK_KP_0 + symbol - DIKS_0;

          switch (symbol) {
               case DIKS_HOME:
                    return XK_KP_Home;

               case DIKS_CURSOR_LEFT:
                    return XK_KP_Left;

               case DIKS_CURSOR_UP:
                    return XK_KP_Up;

               case DIKS_CURSOR_RIGHT:
                    return XK_KP_Right;

               case DIKS_CURSOR_DOWN:
                    return XK_KP_Down;

               case DIKS_PAGE_UP:
                    return XK_KP_Page_Up;

               case DIKS_PAGE_DOWN:
                    return XK_KP_Page_Down;

               case DIKS_END:
                    return XK_KP_End;

               case DIKS_BEGIN:
                    return XK_KP_Begin;

               case DIKS_INSERT:
                    return XK_KP_Insert;

               case DIKS_DELETE:
                    return XK_KP_Delete;

               default:
                    ;
          }

          switch (id) {
               case DIKI_KP_DIV:
                    return XK_KP_Divide;

               case DIKI_KP_MULT:
                    return XK_KP_Multiply;

               case DIKI_KP_MINUS:
                    return XK_KP_Subtract;

               case DIKI_KP_PLUS:
                    return XK_KP_Add;

               case DIKI_KP_ENTER:
                    return XK_KP_Enter;

               case DIKI_KP_SPACE:
                    return XK_KP_Space;

               case DIKI_KP_TAB:
                    return XK_KP_Tab;

               case DIKI_KP_F1:
                    return XK_KP_F1;

               case DIKI_KP_F2:
                    return XK_KP_F2;

               case DIKI_KP_F3:
                    return XK_KP_F3;

               case DIKI_KP_F4:
                    return XK_KP_F4;

               case DIKI_KP_EQUAL:
                    return XK_KP_Equal;

               case DIKI_KP_DECIMAL:
                    return XK_KP_Decimal;

               case DIKI_KP_SEPARATOR:
                    return XK_KP_Separator;

               default:
                    ;
          }
     }

     if (symbol == DIKS_TAB && (index & 1))
          return XK_ISO_Left_Tab;

     if (symbol > 0 && symbol < 256)
          return latin1_to_x[symbol];

     if (DFB_KEY_TYPE (symbol) == DIKT_FUNCTION && symbol < DFB_FUNCTION_KEY(36))
          return XK_F1 + symbol - DIKS_F1;

     switch (id) {
          case DIKI_SHIFT_L:
               return XK_Shift_L;

          case DIKI_SHIFT_R:
               return XK_Shift_R;

          case DIKI_CONTROL_L:
               return XK_Control_L;

          case DIKI_CONTROL_R:
               return XK_Control_R;

          default:
               ;
     }


     switch (symbol) {
          case DIKS_CURSOR_LEFT:
               return XK_Left;

          case DIKS_CURSOR_RIGHT:
               return XK_Right;

          case DIKS_CURSOR_UP:
               return XK_Up;

          case DIKS_CURSOR_DOWN:
               return XK_Down;

          case DIKS_INSERT:
               return XK_Insert;

          case DIKS_HOME:
               return XK_Home;

          case DIKS_END:
               return XK_End;

          case DIKS_PAGE_UP:
               return XK_Page_Up;

          case DIKS_PAGE_DOWN:
               return XK_Page_Down;

          case DIKS_PRINT:
               return XK_Print;

          case DIKS_PAUSE:
               return XK_Pause;

          case DIKS_OK:
               return XK_Return;

          case DIKS_SELECT:
               return XK_Select;

          case DIKS_CLEAR:
               return XK_Clear;

          case DIKS_MENU:
               return XK_Menu;

          case DIKS_HELP:
               return XK_Help;


          case DIKS_ALT:
               return XK_Alt_L;

          case DIKS_ALTGR:
               return XK_Mode_switch;

          case DIKS_META:
               return XK_Meta_L;

          case DIKS_SUPER:
               return XK_Super_L;

          case DIKS_HYPER:
               return XK_Hyper_L;


          case DIKS_CAPS_LOCK:
               return XK_Caps_Lock;

          case DIKS_NUM_LOCK:
               return XK_Num_Lock;

          case DIKS_SCROLL_LOCK:
               return XK_Scroll_Lock;


          case DIKS_DEAD_GRAVE:
               return XK_dead_grave;

          case DIKS_DEAD_ACUTE:
               return XK_dead_acute;

          case DIKS_DEAD_CIRCUMFLEX:
               return XK_dead_circumflex;

          case DIKS_DEAD_TILDE:
               return XK_dead_tilde;

          case DIKS_DEAD_DIAERESIS:
               return XK_dead_diaeresis;

          case DIKS_DEAD_CEDILLA:
               return XK_dead_cedilla;

          default:
               ;
     }

     return 0;
}

/*
 * DirectFBKeyboardInit
 *      Get the DirectFB keyboard map and compute an equivalent
 *      X keyboard map and modifier map. Set the new keyboard
 *      device structure.
 */
void
XDirectFBKeyboardInit (DeviceIntPtr pDev)
{
     int i, n, length;
     DFBInputDeviceDescription desc;

     /* do we have a keyboard? */
     if (!dfbKeyboard)
          return;

     /* fetch device description */
     dfbKeyboard->GetDescription (dfbKeyboard, &desc);

     if (desc.min_keycode < 0 || desc.max_keycode < 0) {
          ErrorF("Keyboards without a map are not supprted yet!\n");
          return;
     }

     memset (directfbModMap, 0, MAP_LENGTH);

     directfbMinScanCode = desc.min_keycode;
     directfbMaxScanCode = desc.max_keycode;

     directfbMinKeyCode  = directfbMinScanCode + DIRECTFB_KEY_OFFSET;
     directfbMaxKeyCode  = directfbMaxScanCode + DIRECTFB_KEY_OFFSET;

     if (directfbMaxKeyCode > DIRECTFB_MAX_KEYCODE)
          directfbMaxKeyCode = DIRECTFB_MAX_KEYCODE;

     length = directfbMaxKeyCode - directfbMinKeyCode + 1;

     for (i=0; i<length; i++) {
          DFBResult                 ret;
          DFBInputDeviceKeymapEntry entry;

          ret = dfbKeyboard->GetKeymapEntry (dfbKeyboard,
                                             i + directfbMinScanCode, &entry);
          if (ret) {
               DirectFBError ("dfbKeyboard->GetKeymapEntry", ret);
               continue;
          }

          for (n=0; n<4; n++)
               directfbKeymap[i*4+n] = XDirectFBTranslateSymbol (&entry, n);
     }

     directfbKeySyms.map        = directfbKeymap;
     directfbKeySyms.minKeyCode = directfbMinKeyCode;
     directfbKeySyms.maxKeyCode = directfbMaxKeyCode;
     directfbKeySyms.mapWidth   = directfbKeymapWidth;

     XDirectFBInitModMap();

     assert( InitKeyboardDeviceStruct( (DevicePtr)pDev,
                                       &directfbKeySyms,
                                       directfbModMap, XDirectFBBell,
                                       XDirectFBChangeKeyboardControl ));
}

/*
 * LegalModifier
 *      This allows the ddx layer to prevent some keys from being remapped
 *      as modifier keys.
 */
Bool
LegalModifier(unsigned int key, DevicePtr pDev)
{
     return TRUE;
}
