/*
   (c) Copyright 2002-2003  Denis Oliver Kropp <dok@directfb.org>
   All rights reserved.

   XDirectFB is mainly based on XDarwin and
   also contains some KDrive, XFree and XWin code.
*/
/**************************************************************
 * quartzPasteboard.c
 *
 * Aqua pasteboard <-> X cut buffer
 * Greg Parker     gparker@cs.stanford.edu     March 8, 2001
 **************************************************************/
/*
 * Copyright (c) 2001 Greg Parker. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name(s) of the above copyright
 * holders shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in this Software without prior written authorization.
 */
/* $XFree86: xc/programs/Xserver/hw/darwin/quartz/quartzPasteboard.c,v 1.1 2002/03/28 02:21:19 torrey Exp $ */

#include "directfbClipboard.h"
#include "directfbPasteboard.h"
#include "directfbScreen.h"

#include "Xatom.h"
#include "windowstr.h"
#include "propertyst.h"
#include "scrnintstr.h"
#include "selection.h"
#include "globals.h"

extern Selection *CurrentSelections;
extern int NumCurrentSelections;

static int
VisitWindow (WindowPtr pWin, pointer data)
{
     DirectFBScreenPtr pScreenPriv = data;

     if (pWin->drawable.id == pScreenPriv->clipboardWindow) {
          pScreenPriv->pClipboardWindow = pWin;

          return WT_STOPWALKING;
     }

     if (!pWin->parent)
          return WT_WALKCHILDREN;

     return WT_DONTWALKCHILDREN;
}

static int
SetPrimarySelectionOwner (ScreenPtr pScreen)
{
     int               i = 0;
     ClientPtr         client;
     DirectFBScreenPtr pScreenPriv = DIRECTFB_PRIV(pScreen);

     /* Find the clipboard window pointer */
     if (!pScreenPriv->pClipboardWindow) {
          if (WalkTree (pScreen, VisitWindow, pScreenPriv) == WT_NOMATCH) {
               ErrorF ("Could not find clipboard window!\n");
               return BadWindow;
          }
     }

     client = wClient( pScreenPriv->pClipboardWindow );

     UpdateCurrentTime();

     /*
      * First, see if the selection is already set... 
      */
     while ((i < NumCurrentSelections) && 
            CurrentSelections[i].selection != XA_PRIMARY)
          i++;

     if (i < NumCurrentSelections) {
          xEvent event;

          if (CurrentSelections[i].client &&
              CurrentSelections[i].client != client)
          {
               event.u.u.type = SelectionClear;
               event.u.selectionClear.time = currentTime.milliseconds;
               event.u.selectionClear.window = CurrentSelections[i].window;
               event.u.selectionClear.atom = CurrentSelections[i].selection;
               (void) TryClientEvents (CurrentSelections[i].client, &event, 1,
                                       NoEventMask, NoEventMask /* CantBeFiltered */,
                                       NullGrab);
          }
     }
     else {
          /*
           * It doesn't exist, so add it...
           */
          Selection *newsels;

          if (i == 0)
               newsels = (Selection *)xalloc(sizeof(Selection));
          else
               newsels = (Selection *)xrealloc(CurrentSelections,
                                               (NumCurrentSelections + 1) * sizeof(Selection));
          if (!newsels)
               return BadAlloc;
          NumCurrentSelections++;
          CurrentSelections = newsels;
          CurrentSelections[i].selection = XA_PRIMARY;
     }

     CurrentSelections[i].lastTimeChanged = currentTime;
     CurrentSelections[i].window = pScreenPriv->clipboardWindow;
     CurrentSelections[i].pWin = pScreenPriv->pClipboardWindow;
     CurrentSelections[i].client = client;

     return Success;
}

static Selection *
GetPrimarySelection()
{
     int sel = 0;

     while ((sel < NumCurrentSelections) &&
            CurrentSelections[sel].selection != XA_PRIMARY)
          sel++;

     if (sel < NumCurrentSelections)
          return &CurrentSelections[sel];

     return NULL;
}

/* Sync X cut buffer */
void XDirectFBClipboardLostFocus(void)
{
     struct timeval stamp;
     unsigned long millis;

     ScreenPtr pScreen = screenInfo.screens[0/*FIXME*/];
     DirectFBScreenPtr pScreenPriv = DIRECTFB_PRIV(pScreen);

     Selection *selection = GetPrimarySelection();

     if (selection == NULL ||
         selection->window == None ||
         selection->window == pScreenPriv->clipboardWindow)
          return;

     dfb->GetClipboardTimeStamp (dfb, &stamp);

     millis = (stamp.tv_sec * 1000) + (stamp.tv_usec / 1000);

     if (selection->lastTimeChanged.milliseconds > millis) {
          xEvent event;

          event.u.u.type                     = SelectionRequest;
          event.u.selectionRequest.time      = GetTimeInMillis();
          event.u.selectionRequest.owner     = selection->window;
          event.u.selectionRequest.requestor = pScreenPriv->clipboardWindow;
          event.u.selectionRequest.selection = XA_PRIMARY;
          event.u.selectionRequest.target    = pScreenPriv->atomCompoundText;
          event.u.selectionRequest.property  = pScreenPriv->atomLocalProperty;

          TryClientEvents (selection->client, &event, 1,
                           NoEventMask, NoEventMask, NullGrab);
     }
}

#define strequal(a, b) (0 == strcmp((a), (b)))

void XDirectFBClipboardGotFocus(void)
{
     struct timeval stamp;
     unsigned long millis;

     ScreenPtr pScreen = screenInfo.screens[0/*FIXME*/];
     DirectFBScreenPtr pScreenPriv = DIRECTFB_PRIV(pScreen);

     Selection *selection = GetPrimarySelection();

     if (selection && selection->window == pScreenPriv->clipboardWindow)
          return;
     
     dfb->GetClipboardTimeStamp (dfb, &stamp);

     millis = (stamp.tv_sec * 1000) + (stamp.tv_usec / 1000);

     if (millis > pScreenPriv->clipboardStamp)
          SetPrimarySelectionOwner (pScreen);
}

