/*
   (c) Copyright 2002-2003  Denis Oliver Kropp <dok@directfb.org>
   All rights reserved.

   XDirectFB is mainly based on XDarwin and
   also contains some KDrive, XFree and XWin code.
*/
/*
 * Rootless setup for Aqua
 *
 * Greg Parker     gparker@cs.stanford.edu
 */
/* $XFree86: xc/programs/Xserver/hw/directfb/bundle/rootlessAqua.h,v 1.2 2001/08/01 05:34:06 torrey Exp $ */

#ifndef _ROOTLESSDIRECTFB_H
#define _ROOTLESSDIRECTFB_H

typedef struct _DirectFBWindowRec DirectFBWindowRec;

/*
 * Setup the screen for rootless access.
 */
Bool XDirectFBRootlessSetupScreen(int index, ScreenPtr pScreen);

/*
 * Destroys all remaining windows for a clean shutdown.
 */
void XDirectFBDestroyAll();

/*
 * Event processing function called from directfbX.c
 *
 * Returns TRUE if the event is relevant for input.
 */
Bool XDirectFBProcessWindowEvent (DFBWindowEvent *event);

/*
 * Bind the cursor shape to all XDirectFB windows.
 */
void XDirectFBSetCursorShape (IDirectFBSurface *shape, int hot_x, int hot_y);

#endif /* _ROOTLESSDIRECTFB_H */
