#############################################################
#
# dhcp
#
#############################################################
ifneq ($(USE_CVS),true)
DHCP_SOURCE:=dhcp.tar.gz
DHCP_SITE:=ftp://ftp.isc.org/isc/dhcp
DHCP_CAT:=zcat
DHCP_DIR:=$(BUILD_DIR)/${shell basename $(DHCP_SOURCE) .tar.gz}

else
# using CVS
DHCP_DIR:=$(BUILD_DIR)/dhcp
endif

DHCP_RELAY_BINARY:=work.linux-2.2/relay/dhcrelay
DHCP_RELAY_TARGET_BINARY:=usr/sbin/dhcrelay

DHCPD_BINARY:=work.linux-2.2/server/dhcpd
DHCPD_TARGET_BINARY:=usr/sbin/dhcpd

DHCLIENT_BINARY:=work.linux-2.2/client/dhclient
DHCLIENT_TARGET_BINARY:=sbin/dhclient

DHCP_BINPROGS = $(DHCP_DIR)/$(DHCPD_BINARY) $(DHCP_DIR)/$(DHCP_RELAY_BINARY) $(DHCP_DIR)/$(DHCLIENT_BINARY)
DHCP_TARGET_BINPROGS = $(TARGET_DIR)/$(DHCPD_TARGET_BINARY) $(TARGET_DIR)/$(DHCP_RELAY_TARGET_BINARY) $(TARGET_DIR)/$(DHCLIENT_TARGET_BINARY)

BVARS=PREDEFINES='-D_PATH_DHCPD_DB=\"/var/lib/dhcp/dhcpd.leases\" \
	-D_PATH_DHCLIENT_DB=\"/var/lib/dhcp/dhclient.leases\" $(TARGET_CFLAGS)' \
	VARDB=/var/lib/dhcp 


ifneq ($(USE_CVS),true)
dhcp-fetch:
	 $(WGET) -P $(DL_DIR) $(DHCP_SITE)/$(DHCP_SOURCE)

dhcp-source: $(DL_DIR)/$(DHCP_SOURCE)
else
dhcp-source:
endif

DHCP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d dhcp $(CVS_TAG) $(CVS_PREFIX)dhcp

dhcp-checkout:
	@$(DHCP_CVSCO)

$(DHCP_DIR)/.unpacked: $(DL_DIR)/$(DHCP_SOURCE)
ifneq ($(USE_CVS),true)
	$(DHCP_CAT) $(DL_DIR)/$(DHCP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(DHCP_CVSCO)
endif
	touch $(DHCP_DIR)/.unpacked

$(DHCP_DIR)/.configured: $(DHCP_DIR)/.unpacked
	(cd $(DHCP_DIR); $(TARGET_CONFIGURE_OPTS) ./configure );
	touch  $(DHCP_DIR)/.configured

$(DHCP_BINPROGS): $(DHCP_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) $(BVARS) -C $(DHCP_DIR)

$(TARGET_DIR)/$(DHCPD_TARGET_BINARY): $(DHCP_BINPROGS)
	install -d $(TARGET_DIR)/var/lib/dhcp
ifeq (1,0)
	cp -a $(DHCP_DIR)/$(DHCPD_BINARY) $(TARGET_DIR)/$(DHCPD_TARGET_BINARY)
	install -m0644 $(DHCP_DIR)/server/*.5 $(TARGET_DIR)/usr/man/man5/
	install -m0644 $(DHCP_DIR)/server/*.8 $(TARGET_DIR)/usr/man/man8/
else
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(DHCP_DIR)/work.linux-2.2/server install
endif
	$(STRIP) $(TARGET_DIR)/$(DHCPD_TARGET_BINARY)
	-mkdir -p $(DOC_DIR)/doc/dhcp
	-install -m0644 $(DHCP_DIR)/COPYRIGHT $(DOC_DIR)/doc/dhcp/
	-install -m0644 $(DHCP_DIR)/README $(DOC_DIR)/doc/dhcp/ 
	-install -m0644 $(DHCP_DIR)/RELNOTES $(DOC_DIR)/doc/dhcp/
	install -m0644 $(DHCP_DIR)/doc/api+protocol $(DOC_DIR)/doc/dhcp/
	install -m0644 $(DHCP_DIR)/doc/IANA-arp-parameters $(DOC_DIR)/doc/dhcp/
	install -m0644 $(DHCP_DIR)/doc/*.txt $(DOC_DIR)/doc/dhcp/

$(TARGET_DIR)/$(DHCLIENT_TARGET_BINARY): $(DHCP_BINPROGS)
	install -d $(TARGET_DIR)/var/lib/dhcp
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(DHCP_DIR)/work.linux-2.2/client install
	$(STRIP) $(TARGET_DIR)/$(DHCLIENT_TARGET_BINARY)
	-mkdir -p $(DOC_DIR)/doc/dhcp
	-install -m0644 $(DHCP_DIR)/COPYRIGHT $(DOC_DIR)/doc/dhcp/
	-install -m0644 $(DHCP_DIR)/README $(DOC_DIR)/doc/dhcp/ 
	-install -m0644 $(DHCP_DIR)/RELNOTES $(DOC_DIR)/doc/dhcp/

$(TARGET_DIR)/$(DHCP_RELAY_TARGET_BINARY): $(DHCP_BINPROGS)
	install -d $(TARGET_DIR)/var/lib/dhcp
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(DHCP_DIR)/work.linux-2.2/relay install
	$(STRIP) $(TARGET_DIR)/$(DHCP_RELAY_TARGET_BINARY)
	-install -m0755 $(DHCP_DIR)/contrib/linux.init $(TARGET_DIR)/rc.d/init.d/dhcpd
	-mkdir -p $(DOC_DIR)/doc/dhcp
	-install -m0644 $(DHCP_DIR)/COPYRIGHT $(DOC_DIR)/doc/dhcp/
	-install -m0644 $(DHCP_DIR)/README $(DOC_DIR)/doc/dhcp/ 
	-install -m0644 $(DHCP_DIR)/RELNOTES $(DOC_DIR)/doc/dhcp/
	-install -d $(TARGET_DIR)/etc/sysconfig
	-echo "#Command line arguments here" >$(TARGET_DIR)/etc/sysconfig/dhcpd
	-echo "DHCPDARGS=-q" >>$(TARGET_DIR)/etc/sysconfig/dhcpd

dhcpd: $(TARGET_DIR)/$(DHCPD_TARGET_BINARY)

dhclient: $(TARGET_DIR)/$(DHCLIENT_TARGET_BINARY)

dhcp_relay: $(TARGET_DIR)/$(DHCP_RELAY_TARGET_BINARY)

dhcp: uclibc $(DHCP_TARGET_BINPROGS)

dhcp-clean:
	# hopefully this is everything
	-rm -f $(DHCP_TARGET_BINPROGS)
	-rm -f $(TARGET_DIR)/sbin/dhclient-script
	-rm -rf $(TARGET_DIR)/var/state/dhcp
	-rm -rf $(TARGET_DIR)/usr/bin/omshell
	-rm -f $(TARGET_DIR)/usr/local/include/dhcpctl.h
	-rm -rf $(TARGET_DIR)/usr/local/include/isc-dhcp
	-rm -rf $(TARGET_DIR)/usr/local/include/omapip
	-rm -f $(TARGET_DIR)/usr/local/lib/libdhcpctl.a
	-rm -f $(TARGET_DIR)/usr/local/lib/libomapi.a
	-rm -f $(TARGET_DIR)/usr/man/man*/dhc*
	-rm -f $(TARGET_DIR)/usr/man/man1/omshell.1
	-$(MAKE) -C $(DHCP_DIR) clean
	-rm -rf $(DOC_DIR)/doc/dhcp

dhcp-dirclean:
	rm -rf $(DHCP_DIR)

