#############################################################
#
# libjpeg
#
#############################################################
ifneq ($(USE_CVS),true)
LIBJPEG_SOURCE:=libjpeg.tar.gz
LIBJPEG_SITE:=ftp://ftp.gnu.org/gnu/libjpeg
LIBJPEG_CAT:=zcat
endif

LIBJPEG_DIR:=$(BUILD_DIR)/libjpeg
LIBJPEG_BINARY:=libjpeg.a
LIBJPEG_TARGET_BINARY:=usr/lib/libjpeg.a

ifneq ($(USE_CVS),true)
libjpeg-fetch:
	 $(WGET) -P $(DL_DIR) $(LIBJPEG_SITE)/$(LIBJPEG_SOURCE)

libjpeg-source: $(DL_DIR)/$(LIBJPEG_SOURCE)
else
libjpeg-source:
endif

LIBJPEG_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d libjpeg $(CVS_TAG) $(CVS_PREFIX)libjpeg

libjpeg-checkout:
	@$(LIBJPEG_CVSCO)

$(LIBJPEG_DIR)/.unpacked: $(DL_DIR)/$(LIBJPEG_SOURCE)
ifneq ($(USE_CVS),true)
	$(LIBJPEG_CAT) $(DL_DIR)/$(LIBJPEG_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LIBJPEG_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(LIBJPEG_DIR)/
	touch $(LIBJPEG_DIR)/.unpacked

$(LIBJPEG_DIR)/.configured: $(LIBJPEG_DIR)/.unpacked
	(cd $(LIBJPEG_DIR); \
		rm -rf config.cache; \
		ac_cv_linux_vers=2 \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--enable-shared \
		--enable-static; \
		./ltconfig ltmain.sh; \
	);
	touch  $(LIBJPEG_DIR)/.configured

$(LIBJPEG_DIR)/$(LIBJPEG_BINARY): $(LIBJPEG_DIR)/.configured
	$(MAKE) ZLIBLIB="-I$(STAGING_DIR)/usr/lib" ZLIBINC="-I$(STAGING_DIR)/usr/include" CC=$(TARGET_CC) -C $(LIBJPEG_DIR)

$(STAGING_DIR)/$(LIBJPEG_TARGET_BINARY): $(LIBJPEG_DIR)/$(LIBJPEG_BINARY)
	$(MAKE) prefix=$(STAGING_DIR)/usr exec_prefix=$(STAGING_DIR)/usr DESTDIR=$(STAGING_DIR) -C $(LIBJPEG_DIR) install
	install -d $(DOC_DIR)/doc/libjpeg
	@for f in README ; do \
		install -m0644 $(LIBJPEG_DIR)/$$f $(DOC_DIR)/doc/libjpeg/$$f ;\
	done
	rm -f $(STAGING_DIR)/usr/lib/libjpeg.la

$(TARGET_DIR)/$(LIBJPEG_TARGET_BINARY): $(STAGING_DIR)/$(LIBJPEG_TARGET_BINARY)
	$(MAKE) prefix=$(TARGET_DIR)/usr exec_prefix=$(TARGET_DIR)/usr DESTDIR=$(TARGET_DIR) -C $(LIBJPEG_DIR) install
	install -d $(DOC_DIR)/doc/libjpeg
	@for f in README ; do \
		install -m0644 $(LIBJPEG_DIR)/$$f $(DOC_DIR)/doc/libjpeg/$$f ;\
	done
	rm -rf $(TARGET_DIR)/include

libjpeg: uclibc $(TARGET_DIR)/$(LIBJPEG_TARGET_BINARY)

libjpeg-clean:
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(LIBJPEG_DIR) uninstall
	-$(MAKE) DESTDIR=$(TARGET_DIR) -C $(LIBJPEG_DIR) uninstall
	-rm -rf $(DOC_DIR)/doc/libjpeg
	-$(MAKE) -C $(LIBJPEG_DIR) clean

libjpeg-dirclean:
	rm -rf $(LIBJPEG_DIR)

